/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.annotations;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee10.webapp.Origin;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;

public class PostConstructAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public PostConstructAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (this.supportsPostConstruct(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                if (method.getParameterCount() != 0) {
                    throw new IllegalStateException(String.valueOf(method) + " has parameters");
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(String.valueOf(method) + " is not void");
                }
                if (method.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(String.valueOf(method) + " throws checked exceptions");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalStateException(String.valueOf(method) + " is static");
                }
                Origin origin = this._context.getMetaData().getOrigin("post-construct");
                if (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride) {
                    return;
                }
                PostConstructCallback callback = new PostConstructCallback(clazz, method.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", (Object)lifecycles);
                }
                lifecycles.add((LifeCycleCallback)callback);
            }
        }
    }

    public boolean supportsPostConstruct(Class<?> c) {
        return PostConstructAnnotationHandler.isAnnotatableServletClass(c);
    }
}

