/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class JidMultiFormField
extends FormField {
    private final List<Jid> values;
    private final List<FormField.Value> rawValues;

    protected JidMultiFormField(Builder builder) {
        super(builder);
        this.values = CollectionUtil.cloneAndSeal(builder.values);
        this.rawValues = CollectionUtil.cloneAndSeal(builder.rawValues);
    }

    public List<Jid> getValues() {
        return this.values;
    }

    @Override
    public List<FormField.Value> getRawValues() {
        return this.rawValues;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends FormField.Builder<JidMultiFormField, Builder> {
        private List<Jid> values;
        private List<FormField.Value> rawValues;

        private Builder(JidMultiFormField jidMultiFormField) {
            super(jidMultiFormField);
            this.values = CollectionUtil.newListWith(jidMultiFormField.getValues());
        }

        Builder(String fieldName) {
            super(fieldName, FormField.Type.jid_multi);
        }

        private void ensureValuesAreInitialized() {
            if (this.values == null) {
                this.values = new ArrayList<Jid>();
                this.rawValues = new ArrayList<FormField.Value>();
            }
        }

        @Override
        protected void resetInternal() {
            this.values = null;
            this.rawValues = null;
        }

        public Builder addValue(Jid jid) {
            FormField.Value value2 = new FormField.Value(jid);
            this.ensureValuesAreInitialized();
            this.values.add(jid);
            this.rawValues.add(value2);
            return this.getThis();
        }

        public Builder addValue(FormField.Value value2) throws XmppStringprepException {
            Jid jid = JidCreate.from(value2.getValue());
            this.ensureValuesAreInitialized();
            this.values.add(jid);
            this.rawValues.add(value2);
            return this;
        }

        public Builder addValues(Collection<? extends Jid> jids) {
            for (Jid jid : jids) {
                this.addValue(jid);
            }
            return this;
        }

        @Override
        public JidMultiFormField build() {
            return new JidMultiFormField(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

