/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptionsConverter;
import io.vertx.core.net.ProxyType;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class ProxyOptions {
    public static final ProxyType DEFAULT_TYPE = ProxyType.HTTP;
    public static final int DEFAULT_PORT = 3128;
    public static final String DEFAULT_HOST = "localhost";
    @GenIgnore(value={"permitted-type"})
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private String host;
    private int port;
    private String username;
    private String password;
    private ProxyType type;
    private Duration connectTimeout;

    public ProxyOptions() {
        this.host = DEFAULT_HOST;
        this.port = 3128;
        this.type = DEFAULT_TYPE;
        this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    }

    public ProxyOptions(ProxyOptions other) {
        this.host = other.getHost();
        this.port = other.getPort();
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.type = other.getType();
        this.connectTimeout = other.getConnectTimeout();
    }

    public ProxyOptions(JsonObject json) {
        this();
        ProxyOptionsConverter.fromJson(json, this);
        Object connectTimeout = json.getValue("connectTimeout");
        if (connectTimeout instanceof Number) {
            this.setConnectTimeout(Duration.of(((Number)connectTimeout).longValue(), ChronoUnit.MILLIS));
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ProxyOptionsConverter.toJson(this, json);
        Duration connectTimeout = this.getConnectTimeout();
        if (connectTimeout != null) {
            json.put("connectTimeout", connectTimeout.toMillis());
        }
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public ProxyOptions setHost(String host) {
        Objects.requireNonNull(host, "Proxy host may not be null");
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid proxy port " + port);
        }
        this.port = port;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ProxyOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public ProxyType getType() {
        return this.type;
    }

    public ProxyOptions setType(ProxyType type) {
        Objects.requireNonNull(type, "Proxy type may not be null");
        this.type = type;
        return this;
    }

    @GenIgnore(value={"permitted-type"})
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @GenIgnore(value={"permitted-type"})
    public ProxyOptions setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }
}

