/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import org.keycloak.common.util.Base64Url;

public class CredentialPublicKeyConverter {
    private CborConverter cborConverter;

    public CredentialPublicKeyConverter(ObjectConverter objectConverter) {
        this.cborConverter = objectConverter.getCborConverter();
    }

    public String convertToDatabaseColumn(COSEKey credentialPublicKey) {
        return Base64Url.encode((byte[])this.cborConverter.writeValueAsBytes((Object)credentialPublicKey));
    }

    public COSEKey convertToEntityAttribute(String s) {
        return (COSEKey)this.cborConverter.readValue(Base64Url.decode((String)s), COSEKey.class);
    }
}

