/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;

public abstract class CastingExpression
extends UnaryExpression {
    private AtomicType targetType;
    private AtomicType targetPrimitiveType;
    private boolean allowEmpty = false;
    protected Converter converter;
    protected NamespaceResolver nsResolver;
    private boolean operandIsStringLiteral = false;

    public CastingExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source);
        this.allowEmpty = allowEmpty;
        this.targetType = target;
        this.targetPrimitiveType = (AtomicType)target.getPrimitiveItemType();
    }

    public AtomicType getTargetPrimitiveType() {
        return this.targetPrimitiveType;
    }

    public void setTargetType(AtomicType type) {
        this.targetType = type;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public void setAllowEmpty(boolean allow) {
        this.allowEmpty = allow;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public void setOperandIsStringLiteral(boolean option) {
        this.operandIsStringLiteral = option;
    }

    public boolean isOperandIsStringLiteral() {
        return this.operandIsStringLiteral;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.nsResolver = resolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        if (this.targetType instanceof BuiltInAtomicType && !env.isAllowedBuiltInType((BuiltInAtomicType)this.targetType)) {
            XPathException err = new XPathException("The type " + this.targetType.getDisplayName() + " is not recognized by a Basic XSLT Processor", this);
            err.setErrorCode("XPST0080");
            err.setIsStaticError(true);
            throw err;
        }
        if (this.nsResolver == null && this.targetType.isNamespaceSensitive()) {
            this.nsResolver = env.getNamespaceResolver();
        }
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }
}

