/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EnclosingMethodAttribute
implements Attribute {
    public static final String NAME = "EnclosingMethod";
    public final String class_name;
    public final String method_name;
    public final String method_descriptor;

    public EnclosingMethodAttribute(String class_name, String method_name, String method_descriptor) {
        this.class_name = class_name;
        this.method_name = method_name;
        this.method_descriptor = method_descriptor;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "EnclosingMethod " + this.class_name + "." + this.method_name + this.method_descriptor;
    }

    public static EnclosingMethodAttribute read(DataInput in, ConstantPool constant_pool) throws IOException {
        String method_descriptor;
        String method_name;
        int class_index = in.readUnsignedShort();
        int method_index = in.readUnsignedShort();
        String class_name = constant_pool.className(class_index);
        if (method_index != 0) {
            ConstantPool.NameAndTypeInfo nameAndType = (ConstantPool.NameAndTypeInfo)constant_pool.entry(method_index);
            method_name = constant_pool.utf8(nameAndType.name_index);
            method_descriptor = constant_pool.utf8(nameAndType.descriptor_index);
        } else {
            method_name = null;
            method_descriptor = null;
        }
        return new EnclosingMethodAttribute(class_name, method_name, method_descriptor);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        int class_index = constant_pool.classInfo(this.class_name);
        int method_index = this.method_name != null ? constant_pool.nameAndTypeInfo(this.method_name, this.method_descriptor) : 0;
        out.writeShort(class_index);
        out.writeShort(method_index);
    }

    @Override
    public int attribute_length() {
        int attribute_length = 4;
        return attribute_length;
    }
}

