/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.util.NbBundle;
import tr.model.action.PeriodYear;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthsOfYearDialog
extends JDialog {
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel daysPanel;
    private JLabel labelApr;
    private JLabel labelAug;
    private JLabel labelDec;
    private JLabel labelFeb;
    private JLabel labelJan;
    private JLabel labelJul;
    private JLabel labelJun;
    private JLabel labelMar;
    private JLabel labelMay;
    private JLabel labelNov;
    private JLabel labelOct;
    private JLabel labelSep;
    private JButton okButton;
    private static final Color SELECTED_BG_COLOR = UIManager.getDefaults().getColor("List.selectionBackground");
    private static final Color SELECTED_FG_COLOR = UIManager.getDefaults().getColor("List.selectionForeground");
    private static final Color DESELECTED_BG_COLOR = UIManager.getDefaults().getColor("List.background");
    private static final Color DESELECTED_FG_COLOR = UIManager.getDefaults().getColor("List.foreground");
    private final Component component;
    private final JLabel[] labels;
    private PeriodYear periodYear;
    private boolean cancelled;

    public MonthsOfYearDialog(Dialog parent, Component component) {
        super(parent, true);
        this.component = component;
        this.periodYear = new PeriodYear();
        this.initComponents();
        this.labels = new JLabel[]{this.labelJan, this.labelFeb, this.labelMar, this.labelApr, this.labelMay, this.labelJun, this.labelJul, this.labelAug, this.labelSep, this.labelOct, this.labelNov, this.labelDec};
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setName(Integer.toString(i));
        }
        this.getRootPane().setDefaultButton(this.okButton);
        ActionListener escapeListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MonthsOfYearDialog.this.cancel(evt);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(escapeListener, stroke, 2);
        this.okButton.requestFocusInWindow();
    }

    public void setPeriodYear(PeriodYear periodYear) {
        if (periodYear == null) {
            return;
        }
        this.periodYear = (PeriodYear)periodYear.clone();
        for (JLabel label : this.labels) {
            this.deselectLabel(label);
        }
        Iterator i$ = periodYear.getSelectedMonths().iterator();
        while (i$.hasNext()) {
            int month = (Integer)i$.next();
            this.selectMonth(month);
        }
    }

    private void selectLabel(JLabel label) {
        if (label == null) {
            return;
        }
        label.setBackground(SELECTED_BG_COLOR);
        label.setForeground(SELECTED_FG_COLOR);
    }

    private void deselectLabel(JLabel label) {
        if (label == null) {
            return;
        }
        label.setBackground(DESELECTED_BG_COLOR);
        label.setForeground(DESELECTED_FG_COLOR);
    }

    private boolean isSelectedMonth(int monthIndex) {
        return this.periodYear.isSelected(Integer.valueOf(monthIndex));
    }

    private void selectMonth(int monthIndex) {
        this.periodYear.select(Integer.valueOf(monthIndex));
        this.selectLabel(this.labels[monthIndex]);
    }

    private void deselectMonth(int monthIndex) {
        this.periodYear.deselected(Integer.valueOf(monthIndex));
        this.deselectLabel(this.labels[monthIndex]);
    }

    public List<Integer> getSelectedMonths() {
        if (this.periodYear == null) {
            return new Vector<Integer>();
        }
        return this.periodYear.getSelectedMonths();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.cancelled = true;
        }
        super.setLocationRelativeTo(this.component);
        super.setVisible(visible);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    private void initComponents() {
        this.daysPanel = new JPanel();
        this.labelJan = new JLabel();
        this.labelFeb = new JLabel();
        this.labelMar = new JLabel();
        this.labelApr = new JLabel();
        this.labelMay = new JLabel();
        this.labelJun = new JLabel();
        this.labelJul = new JLabel();
        this.labelAug = new JLabel();
        this.labelSep = new JLabel();
        this.labelOct = new JLabel();
        this.labelNov = new JLabel();
        this.labelDec = new JLabel();
        this.buttonsPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.title"));
        this.daysPanel.setLayout(new GridLayout(4, 3));
        this.labelJan.setBackground(DESELECTED_BG_COLOR);
        this.labelJan.setFont(this.labelJan.getFont().deriveFont(this.labelJan.getFont().getStyle() | 1));
        this.labelJan.setForeground(DESELECTED_FG_COLOR);
        this.labelJan.setHorizontalAlignment(0);
        this.labelJan.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.jan"));
        this.labelJan.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelJan.setHorizontalTextPosition(0);
        this.labelJan.setOpaque(true);
        this.labelJan.setPreferredSize(new Dimension(34, 34));
        this.labelJan.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelJan);
        this.labelFeb.setBackground(DESELECTED_BG_COLOR);
        this.labelFeb.setFont(this.labelFeb.getFont().deriveFont(this.labelFeb.getFont().getStyle() | 1));
        this.labelFeb.setForeground(DESELECTED_FG_COLOR);
        this.labelFeb.setHorizontalAlignment(0);
        this.labelFeb.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.feb"));
        this.labelFeb.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelFeb.setHorizontalTextPosition(0);
        this.labelFeb.setOpaque(true);
        this.labelFeb.setPreferredSize(new Dimension(34, 34));
        this.labelFeb.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelFeb);
        this.labelMar.setBackground(DESELECTED_BG_COLOR);
        this.labelMar.setFont(this.labelMar.getFont().deriveFont(this.labelMar.getFont().getStyle() | 1));
        this.labelMar.setForeground(DESELECTED_FG_COLOR);
        this.labelMar.setHorizontalAlignment(0);
        this.labelMar.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.march"));
        this.labelMar.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelMar.setHorizontalTextPosition(0);
        this.labelMar.setOpaque(true);
        this.labelMar.setPreferredSize(new Dimension(34, 34));
        this.labelMar.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelMar);
        this.labelApr.setBackground(DESELECTED_BG_COLOR);
        this.labelApr.setFont(this.labelApr.getFont().deriveFont(this.labelApr.getFont().getStyle() | 1));
        this.labelApr.setForeground(DESELECTED_FG_COLOR);
        this.labelApr.setHorizontalAlignment(0);
        this.labelApr.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.apr"));
        this.labelApr.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelApr.setHorizontalTextPosition(0);
        this.labelApr.setOpaque(true);
        this.labelApr.setPreferredSize(new Dimension(34, 34));
        this.labelApr.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelApr);
        this.labelMay.setBackground(DESELECTED_BG_COLOR);
        this.labelMay.setFont(this.labelMay.getFont().deriveFont(this.labelMay.getFont().getStyle() | 1));
        this.labelMay.setForeground(DESELECTED_FG_COLOR);
        this.labelMay.setHorizontalAlignment(0);
        this.labelMay.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.may"));
        this.labelMay.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelMay.setHorizontalTextPosition(0);
        this.labelMay.setOpaque(true);
        this.labelMay.setPreferredSize(new Dimension(34, 34));
        this.labelMay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelMay);
        this.labelJun.setBackground(DESELECTED_BG_COLOR);
        this.labelJun.setFont(this.labelJun.getFont().deriveFont(this.labelJun.getFont().getStyle() | 1));
        this.labelJun.setForeground(DESELECTED_FG_COLOR);
        this.labelJun.setHorizontalAlignment(0);
        this.labelJun.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.jun"));
        this.labelJun.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelJun.setHorizontalTextPosition(0);
        this.labelJun.setOpaque(true);
        this.labelJun.setPreferredSize(new Dimension(34, 34));
        this.labelJun.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelJun);
        this.labelJul.setBackground(DESELECTED_BG_COLOR);
        this.labelJul.setFont(this.labelJul.getFont().deriveFont(this.labelJul.getFont().getStyle() | 1));
        this.labelJul.setForeground(DESELECTED_FG_COLOR);
        this.labelJul.setHorizontalAlignment(0);
        this.labelJul.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.jul"));
        this.labelJul.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelJul.setHorizontalTextPosition(0);
        this.labelJul.setOpaque(true);
        this.labelJul.setPreferredSize(new Dimension(34, 34));
        this.labelJul.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelJul);
        this.labelAug.setBackground(DESELECTED_BG_COLOR);
        this.labelAug.setFont(this.labelAug.getFont().deriveFont(this.labelAug.getFont().getStyle() | 1));
        this.labelAug.setForeground(DESELECTED_FG_COLOR);
        this.labelAug.setHorizontalAlignment(0);
        this.labelAug.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.aug"));
        this.labelAug.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelAug.setHorizontalTextPosition(0);
        this.labelAug.setOpaque(true);
        this.labelAug.setPreferredSize(new Dimension(34, 34));
        this.labelAug.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelAug);
        this.labelSep.setBackground(DESELECTED_BG_COLOR);
        this.labelSep.setFont(this.labelSep.getFont().deriveFont(this.labelSep.getFont().getStyle() | 1));
        this.labelSep.setForeground(DESELECTED_FG_COLOR);
        this.labelSep.setHorizontalAlignment(0);
        this.labelSep.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.sep"));
        this.labelSep.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelSep.setHorizontalTextPosition(0);
        this.labelSep.setOpaque(true);
        this.labelSep.setPreferredSize(new Dimension(34, 34));
        this.labelSep.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelSep);
        this.labelOct.setBackground(DESELECTED_BG_COLOR);
        this.labelOct.setFont(this.labelOct.getFont().deriveFont(this.labelOct.getFont().getStyle() | 1));
        this.labelOct.setForeground(DESELECTED_FG_COLOR);
        this.labelOct.setHorizontalAlignment(0);
        this.labelOct.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.Oct"));
        this.labelOct.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelOct.setHorizontalTextPosition(0);
        this.labelOct.setOpaque(true);
        this.labelOct.setPreferredSize(new Dimension(34, 34));
        this.labelOct.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelOct);
        this.labelNov.setBackground(DESELECTED_BG_COLOR);
        this.labelNov.setFont(this.labelNov.getFont().deriveFont(this.labelNov.getFont().getStyle() | 1));
        this.labelNov.setForeground(DESELECTED_FG_COLOR);
        this.labelNov.setHorizontalAlignment(0);
        this.labelNov.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.nov"));
        this.labelNov.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelNov.setHorizontalTextPosition(0);
        this.labelNov.setOpaque(true);
        this.labelNov.setPreferredSize(new Dimension(34, 34));
        this.labelNov.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelNov);
        this.labelDec.setBackground(DESELECTED_BG_COLOR);
        this.labelDec.setFont(this.labelDec.getFont().deriveFont(this.labelDec.getFont().getStyle() | 1));
        this.labelDec.setForeground(DESELECTED_FG_COLOR);
        this.labelDec.setHorizontalAlignment(0);
        this.labelDec.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"MonthsDialog.dec"));
        this.labelDec.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.labelDec.setHorizontalTextPosition(0);
        this.labelDec.setOpaque(true);
        this.labelDec.setPreferredSize(new Dimension(34, 34));
        this.labelDec.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MonthsOfYearDialog.this.monthMouseClicked(evt);
            }
        });
        this.daysPanel.add(this.labelDec);
        this.getContentPane().add((Component)this.daysPanel, "Center");
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MonthsOfYearDialog.this.cancel(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.okButton.setText(NbBundle.getMessage(MonthsOfYearDialog.class, (String)"Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MonthsOfYearDialog.this.done(evt);
            }
        });
        this.buttonsPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonsPanel, "Last");
        this.pack();
    }

    private void done(ActionEvent evt) {
        this.cancelled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void cancel(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void monthMouseClicked(MouseEvent evt) {
        try {
            JLabel dayLabel = (JLabel)evt.getSource();
            int monthIndex = Integer.parseInt(dayLabel.getName());
            if (this.isSelectedMonth(monthIndex)) {
                this.deselectMonth(monthIndex);
            } else {
                this.selectMonth(monthIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

