/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PaddingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PaddingExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PaddingExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PaddingExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaddingExtensionHandler
extends ExtensionHandler<PaddingExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PaddingExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public PaddingExtensionParser getParser(byte[] message, int pointer) {
        return new PaddingExtensionParser(pointer, message);
    }

    public PaddingExtensionPreparator getPreparator(PaddingExtensionMessage message) {
        return new PaddingExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public PaddingExtensionSerializer getSerializer(PaddingExtensionMessage message) {
        return new PaddingExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(PaddingExtensionMessage message) {
        this.context.setPaddingExtensionBytes((byte[])message.getPaddingBytes().getValue());
        LOGGER.debug("The context PaddingExtension bytes were set to " + ArrayConverter.bytesToHexString((byte[])this.context.getPaddingExtensionBytes()));
    }
}

