/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.crypto.EncAlgo;
import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.MuxedPQSKM;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

final class MuxedPQEngine {
    private final RouterContext _context;
    private final Log _log;

    public MuxedPQEngine(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(MuxedPQEngine.class);
    }

    public CloveSet decrypt(byte[] data, PrivateKey ecKey, PrivateKey pqKey, MuxedPQSKM keyManager) throws DataFormatException {
        if (ecKey.getType() != EncType.ECIES_X25519 || pqKey.getType().getBaseAlgorithm() != EncAlgo.ECIES_MLKEM) {
            throw new IllegalArgumentException();
        }
        boolean debug = this._log.shouldDebug();
        CloveSet rv = null;
        boolean preferRatchet = keyManager.preferRatchet();
        if (preferRatchet) {
            rv = this._context.eciesEngine().decryptFast(data, ecKey, keyManager.getECSKM());
            if (rv != null) {
                return rv;
            }
            if (debug) {
                this._log.debug("Ratchet tag not found before PQ");
            }
        }
        if ((rv = this._context.eciesEngine().decryptFast(data, pqKey, keyManager.getPQSKM())) != null) {
            return rv;
        }
        if (debug) {
            this._log.debug("PQ tag not found");
        }
        if (!preferRatchet) {
            rv = this._context.eciesEngine().decryptFast(data, ecKey, keyManager.getECSKM());
            if (rv != null) {
                return rv;
            }
            if (debug) {
                this._log.debug("Ratchet tag not found after PQ");
            }
        }
        if (preferRatchet) {
            rv = this._context.eciesEngine().decryptSlow(data, ecKey, keyManager.getECSKM());
            boolean ok = rv != null;
            keyManager.reportDecryptResult(true, ok);
            if (ok) {
                return rv;
            }
            if (debug) {
                this._log.debug("Ratchet NS decrypt failed before PQ");
            }
        }
        boolean isok = (rv = this._context.eciesEngine().decryptSlow(data, pqKey, keyManager.getPQSKM())) != null;
        keyManager.reportDecryptResult(false, isok);
        if (isok) {
            return rv;
        }
        if (debug) {
            this._log.debug("PQ NS decrypt failed");
        }
        if (!preferRatchet) {
            rv = this._context.eciesEngine().decryptSlow(data, ecKey, keyManager.getECSKM());
            boolean ok = rv != null;
            keyManager.reportDecryptResult(true, ok);
            if (!ok && debug) {
                this._log.debug("Ratchet NS decrypt failed after PQ");
            }
        }
        return rv;
    }
}

