/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.rtcp.KeyframeRequester;
import org.jitsi.nlj.rtcp.NackHandler;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpSrUpdater;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation.GoogleCcEstimator;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.transform.NodeEventVisitor;
import org.jitsi.nlj.transform.NodeStatsVisitor;
import org.jitsi.nlj.transform.NodeTeardownVisitor;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.AudioRedHandler;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.PacketCacher;
import org.jitsi.nlj.transform.node.PacketLossConfig;
import org.jitsi.nlj.transform.node.PacketLossNode;
import org.jitsi.nlj.transform.node.PacketStreamStatsNode;
import org.jitsi.nlj.transform.node.PluggableTransformerNode;
import org.jitsi.nlj.transform.node.SrtcpEncryptNode;
import org.jitsi.nlj.transform.node.SrtpEncryptNode;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.outgoing.AbsSendTime;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtEncoder;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtStripper;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsTracker;
import org.jitsi.nlj.transform.node.outgoing.ProbingDataSender;
import org.jitsi.nlj.transform.node.outgoing.RetransmissionSender;
import org.jitsi.nlj.transform.node.outgoing.SentRtcpStats;
import org.jitsi.nlj.transform.node.outgoing.TccSeqNumTagger;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001J\u0018\u0000 y2\u00020\u0001:\u0001yBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020RH\u0014J\u001e\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020&0V2\u0006\u0010W\u001a\u00020TH\u0016J\u0010\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00020*H\u0016J\u0010\u0010Z\u001a\u00020M2\u0006\u0010[\u001a\u00020\\H\u0016J\u0017\u0010]\u001a\u00020M2\b\u0010^\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010_J\u0010\u0010`\u001a\u00020M2\u0006\u0010a\u001a\u00020bH\u0016J\u0018\u0010c\u001a\u00020M2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020 H\u0016J\u0010\u0010g\u001a\u00020 2\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010h\u001a\u00020 2\u0006\u0010Q\u001a\u00020RH\u0002J\b\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020M2\u0006\u0010p\u001a\u00020qH\u0016J\b\u0010r\u001a\u00020sH\u0016J\b\u0010t\u001a\u00020MH\u0016J\b\u0010u\u001a\u00020MH\u0016J\u0010\u0010v\u001a\u00020M2\u0006\u0010w\u001a\u00020xH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0012\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0012\u0010(\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010K\u00a8\u0006z"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl;", "Lorg/jitsi/nlj/RtpSender;", "id", "", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "executor", "Ljava/util/concurrent/ExecutorService;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Ljava/lang/String;Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/nlj/util/StreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getId", "()Ljava/lang/String;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "getBackgroundExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "logger", "outgoingRtpRoot", "Lorg/jitsi/nlj/transform/node/Node;", "outgoingRtxRoot", "outgoingRtcpRoot", "incomingPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "localVideoSsrc", "", "Ljava/lang/Long;", "localAudioSsrc", "outgoingPacketHandler", "Lorg/jitsi/nlj/PacketHandler;", "bandwidthEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "getBandwidthEstimator", "()Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "transportCcEngine", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "srtpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtpEncryptNode;", "srtcpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtcpEncryptNode;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "outgoingPacketCache", "Lorg/jitsi/nlj/transform/node/PacketCacher;", "headerExtensionStripper", "Lorg/jitsi/nlj/transform/node/outgoing/HeaderExtStripper;", "absSendTime", "Lorg/jitsi/nlj/transform/node/outgoing/AbsSendTime;", "statsTracker", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "packetStreamStats", "Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode;", "rtcpSrUpdater", "Lorg/jitsi/nlj/rtcp/RtcpSrUpdater;", "keyframeRequester", "Lorg/jitsi/nlj/rtcp/KeyframeRequester;", "probingDataSender", "Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender;", "nackHandler", "Lorg/jitsi/nlj/rtcp/NackHandler;", "outputPipelineTerminationNode", "org/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1", "Lorg/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1;", "onRttUpdate", "", "newRttMs", "", "doProcessPacket", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "sendProbing", "", "mediaSsrcs", "", "numBytes", "onOutgoingPacket", "handler", "setSrtpTransformers", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "requestKeyframe", "mediaSsrc", "(Ljava/lang/Long;)V", "addLossListener", "lossListener", "Lorg/jitsi/nlj/rtp/LossListener;", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "isFeatureEnabled", "handlePacket", "getStreamStats", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getPacketStreamStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getTransportCcEngineStats", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "stop", "tearDown", "addRtpExtensionToRetain", "extensionType", "Lorg/jitsi/nlj/rtp/RtpExtensionType;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtpSenderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtpSenderImpl.kt\norg/jitsi/nlj/RtpSenderImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 SupplierBuilder.kt\norg/jitsi/metaconfig/SupplierBuilderKt\n+ 4 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,356:1\n63#2,4:357\n127#3:361\n59#4:362\n*S KotlinDebug\n*F\n+ 1 RtpSenderImpl.kt\norg/jitsi/nlj/RtpSenderImpl\n*L\n138#1:357,4\n348#1:361\n348#1:362\n*E\n"})
public final class RtpSenderImpl
extends RtpSender {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Node outgoingRtpRoot;
    @NotNull
    private final Node outgoingRtxRoot;
    @NotNull
    private final Node outgoingRtcpRoot;
    @NotNull
    private final PacketInfoQueue incomingPacketQueue;
    private boolean running;
    @Nullable
    private Long localVideoSsrc;
    @Nullable
    private Long localAudioSsrc;
    @Nullable
    private PacketHandler outgoingPacketHandler;
    @NotNull
    private final BandwidthEstimator bandwidthEstimator;
    @NotNull
    private final TransportCcEngine transportCcEngine;
    @NotNull
    private final SrtpEncryptNode srtpEncryptWrapper;
    @NotNull
    private final SrtcpEncryptNode srtcpEncryptWrapper;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final PacketCacher outgoingPacketCache;
    @NotNull
    private final HeaderExtStripper headerExtensionStripper;
    @NotNull
    private final AbsSendTime absSendTime;
    @NotNull
    private final OutgoingStatisticsTracker statsTracker;
    @NotNull
    private final PacketStreamStatsNode packetStreamStats;
    @NotNull
    private final RtcpSrUpdater rtcpSrUpdater;
    @NotNull
    private final KeyframeRequester keyframeRequester;
    @NotNull
    private final ProbingDataSender probingDataSender;
    @NotNull
    private final NackHandler nackHandler;
    @NotNull
    private final outputPipelineTerminationNode.1 outputPipelineTerminationNode;
    @NotNull
    private static CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final String PACKET_QUEUE_ENTRY_EVENT = "Entered RTP sender incoming queue";
    @NotNull
    private static final String PACKET_QUEUE_EXIT_EVENT = "Exited RTP sender incoming queue";
    @NotNull
    private static final ConfigDelegate<Integer> queueSize$delegate;
    @NotNull
    private static final PacketLossConfig packetLossConfig;

    public RtpSenderImpl(@NotNull String id, @NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull StreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.id = id;
        this.rtcpEventNotifier = rtcpEventNotifier2;
        this.executor = executor;
        this.backgroundExecutor = backgroundExecutor;
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.incomingPacketQueue = new PacketInfoQueue("rtp-sender-incoming-packet-queue", this.executor, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return RtpSenderImpl.access$handlePacket((RtpSenderImpl)this.receiver, p0);
            }
        }, RtpSenderImpl.Companion.getQueueSize());
        this.running = true;
        this.bandwidthEstimator = new GoogleCcEstimator(diagnosticContext, this.logger);
        this.transportCcEngine = new TransportCcEngine(this.getBandwidthEstimator(), this.logger, null, 4, null);
        this.srtpEncryptWrapper = new SrtpEncryptNode();
        this.srtcpEncryptWrapper = new SrtcpEncryptNode();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-tx");
        this.outgoingPacketCache = new PacketCacher();
        this.headerExtensionStripper = new HeaderExtStripper(this.streamInformationStore);
        this.absSendTime = new AbsSendTime(this.streamInformationStore);
        this.statsTracker = new OutgoingStatisticsTracker();
        this.packetStreamStats = new PacketStreamStatsNode(diagnosticContext, "send", null, 4, null);
        this.rtcpSrUpdater = new RtcpSrUpdater(this.statsTracker);
        this.keyframeRequester = new KeyframeRequester(this.streamInformationStore, this.logger, null, 4, null);
        this.outputPipelineTerminationNode = new ConsumerNode(this){
            private final String aggregationKey;
            final /* synthetic */ RtpSenderImpl this$0;
            {
                this.this$0 = $receiver;
                super("Output pipeline termination node");
                this.aggregationKey = this.getName();
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                PacketHandler packetHandler = RtpSenderImpl.access$getOutgoingPacketHandler$p(this.this$0);
                if (packetHandler != null) {
                    packetHandler.processPacket(packetInfo);
                } else {
                    this.packetDiscarded(packetInfo);
                }
            }

            protected String getAggregationKey() {
                return this.aggregationKey;
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        };
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Sender " + this.id + " using executor " + this.executor.hashCode());
        }
        if (packetLossConfig.getEnabled()) {
            this.logger.warn("Will simulate packet loss: " + packetLossConfig);
        }
        this.incomingPacketQueue.setErrorHandler(queueErrorCounter);
        this.outgoingRtpRoot = PipelineDslKt.pipeline(arg_0 -> RtpSenderImpl._init_$lambda$3(this, arg_0));
        this.outgoingRtxRoot = PipelineDslKt.pipeline(arg_0 -> RtpSenderImpl._init_$lambda$4(this, arg_0));
        this.nackHandler = new NackHandler(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.logger);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.nackHandler, false, 2, null);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.transportCcEngine, false, 2, null);
        this.outgoingRtcpRoot = PipelineDslKt.pipeline(arg_0 -> RtpSenderImpl._init_$lambda$8(this, arg_0));
        this.probingDataSender = new ProbingDataSender(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.absSendTime, diagnosticContext, this.streamInformationStore, this.logger);
    }

    public /* synthetic */ RtpSenderImpl(String string, RtcpEventNotifier rtcpEventNotifier2, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, StreamInformationStore streamInformationStore, Logger logger, DiagnosticContext diagnosticContext, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x40) != 0) {
            diagnosticContext = new DiagnosticContext();
        }
        this(string, rtcpEventNotifier2, executorService, scheduledExecutorService, streamInformationStore, logger, diagnosticContext);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ExecutorService getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ScheduledExecutorService getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    @NotNull
    public BandwidthEstimator getBandwidthEstimator() {
        return this.bandwidthEstimator;
    }

    @Override
    public void onRttUpdate(double newRttMs) {
        this.nackHandler.onRttUpdate(newRttMs);
        this.keyframeRequester.onRttUpdate(newRttMs);
        Duration duration = Duration.ofNanos((long)(newRttMs * 1000000.0));
        Intrinsics.checkNotNullExpressionValue(duration, "ofNanos(...)");
        this.transportCcEngine.onRttUpdate(duration);
    }

    @Override
    protected void doProcessPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (this.running) {
            packetInfo.addEvent(PACKET_QUEUE_ENTRY_EVENT);
            this.incomingPacketQueue.add(packetInfo);
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
            function1.invoke(packetInfo.getPacket().buffer);
        }
    }

    @Override
    public int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, "mediaSsrcs");
        return this.probingDataSender.sendProbing(mediaSsrcs, numBytes);
    }

    @Override
    public void onOutgoingPacket(@NotNull PacketHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.outgoingPacketHandler = handler;
    }

    @Override
    public void setSrtpTransformers(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.srtpEncryptWrapper.setTransformer(srtpTransformers.getSrtpEncryptTransformer());
        this.srtcpEncryptWrapper.setTransformer(srtpTransformers.getSrtcpEncryptTransformer());
    }

    @Override
    public void requestKeyframe(@Nullable Long mediaSsrc) {
        this.keyframeRequester.requestKeyframe(mediaSsrc);
    }

    @Override
    public void addLossListener(@NotNull LossListener lossListener) {
        Intrinsics.checkNotNullParameter(lossListener, "lossListener");
        this.transportCcEngine.addLossListener(lossListener);
    }

    @Override
    public void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] == 1) {
            if (enabled2) {
                this.toggleablePcapWriter.enable();
            } else {
                this.toggleablePcapWriter.disable();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.toggleablePcapWriter.isEnabled();
    }

    private final boolean handlePacket(PacketInfo packetInfo) {
        boolean bl;
        if (this.running) {
            packetInfo.addEvent(PACKET_QUEUE_EXIT_EVENT);
            Node root = packetInfo.getPacket() instanceof RtcpPacket ? this.outgoingRtcpRoot : this.outgoingRtpRoot;
            root.processPacket(packetInfo);
            bl = true;
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "buffer");
            function1.invoke(packetInfo.getPacket().buffer);
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public OutgoingStatisticsSnapshot getStreamStats() {
        return this.statsTracker.getSnapshot();
    }

    @Override
    @NotNull
    public PacketStreamStats.Snapshot getPacketStreamStats() {
        return this.packetStreamStats.snapshot();
    }

    @Override
    @NotNull
    public TransportCcEngine.StatisticsSnapshot getTransportCcEngineStats() {
        return this.transportCcEngine.getStatistics();
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetLocalSsrcEvent) {
            switch (WhenMappings.$EnumSwitchMapping$1[((SetLocalSsrcEvent)event).getMediaType().ordinal()]) {
                case 1: {
                    this.localVideoSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                    break;
                }
                case 2: {
                    this.localAudioSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                }
            }
        }
        new NodeEventVisitor(event).reverseVisit(this.outputPipelineTerminationNode);
        this.probingDataSender.handleEvent(event);
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u249 = nodeStatsBlock = new NodeStatsBlock("RTP sender " + this.id);
        boolean bl = false;
        $this$getNodeStats_u24lambda_u249.addBlock(super.getNodeStats());
        $this$getNodeStats_u24lambda_u249.addBlock(this.nackHandler.getNodeStats());
        $this$getNodeStats_u24lambda_u249.addBlock(this.probingDataSender.getNodeStats());
        JSONObject jSONObject = this.incomingPacketQueue.getDebugState();
        Intrinsics.checkNotNullExpressionValue(jSONObject, "getDebugState(...)");
        $this$getNodeStats_u24lambda_u249.addJson("packetQueue", jSONObject);
        new NodeStatsVisitor($this$getNodeStats_u24lambda_u249).reverseVisit(this.outputPipelineTerminationNode);
        $this$getNodeStats_u24lambda_u249.addString("running", String.valueOf(this.running));
        Object object = this.localVideoSsrc;
        if (object == null || (object = ((Long)object).toString()) == null) {
            object = "null";
        }
        $this$getNodeStats_u24lambda_u249.addString("localVideoSsrc", (String)object);
        Object object2 = this.localAudioSsrc;
        if (object2 == null || (object2 = ((Long)object2).toString()) == null) {
            object2 = "null";
        }
        $this$getNodeStats_u24lambda_u249.addString("localAudioSsrc", (String)object2);
        $this$getNodeStats_u24lambda_u249.addJson("transportCcEngine", this.transportCcEngine.getStatistics().toJson());
        $this$getNodeStats_u24lambda_u249.addJson("Bandwidth Estimation", BandwidthEstimator.getStats$default(this.getBandwidthEstimator(), null, 1, null).toJson());
        return nodeStatsBlock;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void tearDown() {
        this.logger.info("Tearing down");
        new NodeTeardownVisitor().reverseVisit(this.outputPipelineTerminationNode);
        this.incomingPacketQueue.close();
        this.toggleablePcapWriter.disable();
    }

    @Override
    public void addRtpExtensionToRetain(@NotNull RtpExtensionType extensionType) {
        Intrinsics.checkNotNullParameter((Object)extensionType, "extensionType");
        this.headerExtensionStripper.addRtpExtensionToRetain(extensionType);
    }

    private static final Function1 lambda$3$lambda$1(RtpSenderImpl this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getPreProcesor();
    }

    private static final boolean lambda$3$lambda$2() {
        return packetLossConfig.getEnabled();
    }

    private static final Unit _init_$lambda$3(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new PluggableTransformerNode("RTP pre-processor", () -> RtpSenderImpl.lambda$3$lambda$1(this$0)), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new AudioRedHandler(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.headerExtensionStripper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.outgoingPacketCache, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.absSendTime, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.statsTracker, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new TccSeqNumTagger(this$0.transportCcEngine, this$0.streamInformationStore), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new HeaderExtEncoder(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.toggleablePcapWriter.newObserverNode(true), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.srtpEncryptWrapper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.packetStreamStats.createNewNode(), null, 2, null);
        $this$pipeline.node(new PacketLossNode(packetLossConfig), RtpSenderImpl::lambda$3$lambda$2);
        PipelineBuilder.node$default($this$pipeline, this$0.outputPipelineTerminationNode, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new RetransmissionSender(this$0.streamInformationStore, this$0.logger), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.absSendTime, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Function1 lambda$8$lambda$5(RtpSenderImpl this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getPreProcesor();
    }

    private static final PacketInfo lambda$8$lambda$6(RtpSenderImpl this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Long l = this$0.localVideoSsrc;
        if (l == null) {
            return packetInfo;
        }
        long senderSsrc = l;
        RtcpPacket rtcpPacket = (RtcpPacket)packetInfo.packetAs();
        if (rtcpPacket.getSenderSsrc() == 0L) {
            rtcpPacket.setSenderSsrc(senderSsrc);
        }
        return packetInfo;
    }

    private static final boolean lambda$8$lambda$7() {
        return packetLossConfig.getEnabled();
    }

    private static final Unit _init_$lambda$8(RtpSenderImpl this$0, PipelineBuilder $this$pipeline) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
        PipelineBuilder.node$default($this$pipeline, new PluggableTransformerNode("RTCP pre-processor", () -> RtpSenderImpl.lambda$8$lambda$5(this$0)), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.keyframeRequester, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new SentRtcpStats(), null, 2, null);
        $this$pipeline.simpleNode("RTCP sender ssrc setter", arg_0 -> RtpSenderImpl.lambda$8$lambda$6(this$0, arg_0));
        PipelineBuilder.node$default($this$pipeline, this$0.rtcpSrUpdater, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.toggleablePcapWriter.newObserverNode(true), null, 2, null);
        PipelineBuilder.node$default($this$pipeline, new ObserverNode(this$0){
            final /* synthetic */ RtpSenderImpl this$0;
            {
                this.this$0 = $receiver;
                super("RTCP sent notifier");
            }

            protected void observe(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                Packet packet = packetInfo.getPacket();
                if (packet instanceof RtcpPacket) {
                    RtcpEventNotifier.notifyRtcpSent$default(RtpSenderImpl.access$getRtcpEventNotifier$p(this.this$0), (RtcpPacket)packet, false, 2, null);
                }
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
            }
        }, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.srtcpEncryptWrapper, null, 2, null);
        PipelineBuilder.node$default($this$pipeline, this$0.packetStreamStats.createNewNode(), null, 2, null);
        $this$pipeline.node(new PacketLossNode(packetLossConfig), RtpSenderImpl::lambda$8$lambda$7);
        PipelineBuilder.node$default($this$pipeline, this$0.outputPipelineTerminationNode, null, 2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RtcpEventNotifier access$getRtcpEventNotifier$p(RtpSenderImpl $this) {
        return $this.rtcpEventNotifier;
    }

    public static final /* synthetic */ boolean access$handlePacket(RtpSenderImpl $this, PacketInfo packetInfo) {
        return $this.handlePacket(packetInfo);
    }

    public static final /* synthetic */ PacketHandler access$getOutgoingPacketHandler$p(RtpSenderImpl $this) {
        return $this.outgoingPacketHandler;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        Companion = new Companion(null);
        queueErrorCounter = new CountingErrorHandler();
        String string = "jmt.transceiver.send.queue-size";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        queueSize$delegate = new ConfigDelegate(supplier$iv);
        packetLossConfig = new PacketLossConfig("jmt.debug.packet-loss.outgoing");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl$Companion;", "", "<init>", "()V", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "setQueueErrorCounter", "(Lorg/jitsi/utils/queue/CountingErrorHandler;)V", "PACKET_QUEUE_ENTRY_EVENT", "", "PACKET_QUEUE_EXIT_EVENT", "queueSize", "", "getQueueSize", "()I", "queueSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "packetLossConfig", "Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        public final void setQueueErrorCounter(@NotNull CountingErrorHandler countingErrorHandler) {
            Intrinsics.checkNotNullParameter(countingErrorHandler, "<set-?>");
            queueErrorCounter = countingErrorHandler;
        }

        private final int getQueueSize() {
            return ((Number)queueSize$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "queueSize", "getQueueSize()I", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Features.values().length];
            try {
                nArray[Features.TRANSCEIVER_PCAP_DUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

