/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.util.Objects;

public interface MessageView
extends StanzaView {
    public Message.Type getType();

    default public String getSubject() {
        return this.getSubject(null);
    }

    default public String getSubject(String language) {
        Message.Subject subject = this.getMessageSubject(language);
        return subject == null ? null : subject.getSubject();
    }

    default public Message.Subject getMessageSubject(String language) {
        language = Stanza.determineLanguage(this, language);
        for (Message.Subject subject : this.getSubjects()) {
            if (!Objects.equals(language, subject.getLanguage()) && (subject.getLanguage() != null || !Objects.equals(this.getLanguage(), language))) continue;
            return subject;
        }
        return null;
    }

    default public Set<Message.Subject> getSubjects() {
        List<Message.Subject> subjectList = this.getExtensions(Message.Subject.class);
        HashSet<Message.Subject> subjects = new HashSet<Message.Subject>(subjectList.size());
        subjects.addAll(subjectList);
        return subjects;
    }

    default public List<String> getSubjectLanguages() {
        Message.Subject defaultSubject = this.getMessageSubject(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Message.Subject subject : this.getExtensions(Message.Subject.class)) {
            if (subject.equals(defaultSubject)) continue;
            languages.add(subject.getLanguage());
        }
        return Collections.unmodifiableList(languages);
    }

    default public String getBody() {
        return this.getBody(this.getLanguage());
    }

    default public String getBody(String language) {
        Message.Body body = this.getMessageBody(language);
        return body == null ? null : body.getMessage();
    }

    default public Message.Body getMessageBody(String language) {
        language = Stanza.determineLanguage(this, language);
        for (Message.Body body : this.getBodies()) {
            if (!Objects.equals(language, body.getLanguage()) && (language == null || !language.equals(this.getLanguage()) || body.getLanguage() != null)) continue;
            return body;
        }
        return null;
    }

    default public Set<Message.Body> getBodies() {
        List<ExtensionElement> bodiesList = this.getExtensions(Message.Body.QNAME);
        HashSet<Message.Body> resultSet = new HashSet<Message.Body>(bodiesList.size());
        for (ExtensionElement extensionElement : bodiesList) {
            Message.Body body = (Message.Body)extensionElement;
            resultSet.add(body);
        }
        return resultSet;
    }

    default public List<String> getBodyLanguages() {
        Message.Body defaultBody = this.getMessageBody(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Message.Body body : this.getBodies()) {
            if (body.equals(defaultBody)) continue;
            languages.add(body.getLanguage());
        }
        return Collections.unmodifiableList(languages);
    }

    default public String getThread() {
        Message.Thread thread2 = this.getExtension(Message.Thread.class);
        if (thread2 == null) {
            return null;
        }
        return thread2.getThread();
    }
}

