/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static InputStream getInputStreamForClasspathFile(String path) {
        return FileUtils.getInputStreamForClasspathFile(path, null);
    }

    public static InputStream getInputStreamForClasspathFile(String path, ClassLoader loader) {
        try {
            return FileUtils.getStreamForClasspathFile(path, loader);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Suppressed IOException in getInputStreamForClasspathFile", e);
            return null;
        }
    }

    public static InputStream getStreamForClasspathFile(String path, ClassLoader loader) throws IOException {
        List<ClassLoader> classLoaders = FileUtils.getClassLoaders();
        if (loader != null) {
            classLoaders.add(0, loader);
        }
        for (ClassLoader classLoader : classLoaders) {
            InputStream is = classLoader.getResourceAsStream(path);
            if (is == null) continue;
            return is;
        }
        throw new IOException("Unable to get '" + path + "' from classpath. Tried ClassLoaders:" + classLoaders);
    }

    public static InputStream getStreamForUri(URI uri, ClassLoader loader) throws IOException {
        String protocol = uri.getScheme();
        if (protocol.equals("classpath")) {
            String path = uri.getSchemeSpecificPart();
            return FileUtils.getStreamForClasspathFile(path, loader);
        }
        URL url = uri.toURL();
        return url.openStream();
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{FileUtils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(classLoaders.length);
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            loaders.add(classLoader);
        }
        return loaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addLines(String uriString, Set<String> set) throws MalformedURLException, IOException {
        URI uri = URI.create(uriString);
        InputStream is = FileUtils.getStreamForUri(uri, null);
        InputStreamReader sr = new InputStreamReader(is, StandardCharsets.UTF_8);
        try (BufferedReader br = new BufferedReader(sr);){
            String line;
            while ((line = br.readLine()) != null) {
                set.add(line);
            }
        }
        return true;
    }

    public static String readFileOrThrow(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            int len;
            char[] buf = new char[8192];
            StringBuilder s2 = new StringBuilder();
            while ((len = reader.read(buf)) >= 0) {
                s2.append(buf, 0, len);
            }
            String string = s2.toString();
            return string;
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFileOrThrow(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "readFile", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "readFile", e);
        }
        return null;
    }

    public static void writeFileOrThrow(File file, CharSequence content) throws IOException {
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content.toString());
        }
    }

    public static boolean writeFile(File file, CharSequence content) {
        try {
            FileUtils.writeFileOrThrow(file, content);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "writeFile", e);
            return false;
        }
    }

    public static FileOutputStream prepareFileOutputStream(File file) throws IOException {
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("Cannot create directory " + parent.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                throw new IOException("Cannot create file " + file.getAbsolutePath());
            }
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("File " + file.getAbsolutePath() + " is not a file!"));
        }
        return new FileOutputStream(file);
    }

    public static FileInputStream prepareFileInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                return new FileInputStream(file);
            }
            throw new IOException("File " + file.getAbsolutePath() + " is not a file!");
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found.");
    }

    public static void maybeDeleteFileOrThrow(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        boolean successfullyDeleted = file.delete();
        if (!successfullyDeleted) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public static void maybeCreateFileWithParentDirectories(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create directory " + parent);
        }
        if (file.isFile()) {
            return;
        }
        if (!file.exists()) {
            if (file.createNewFile()) {
                return;
            }
            throw new IOException("Cannot create file " + file);
        }
        if (file.isDirectory()) {
            throw new IOException("File " + file + " exists, but is a directory.");
        }
        throw new IOException("File " + file + " exists, but is neither a file nor a directory");
    }
}

