/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;

public class Base32 {
    private static final StringEncoder<String> base32Stringencoder = new StringEncoder<String>(){

        @Override
        public String encode(String string) {
            return Base32.encode(string);
        }

        @Override
        public String decode(String string) {
            return Base32.decode(string);
        }
    };
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";

    public static StringEncoder<String> getStringEncoder() {
        return base32Stringencoder;
    }

    public static String decode(String str) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] raw = str.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < raw.length; ++i) {
            char c = (char)raw[i];
            if (Character.isWhitespace(c)) continue;
            c = Character.toUpperCase(c);
            bs.write((byte)c);
        }
        while (bs.size() % 8 != 0) {
            bs.write(56);
        }
        byte[] in = bs.toByteArray();
        bs.reset();
        DataOutputStream ds = new DataOutputStream(bs);
        for (int i = 0; i < in.length / 8; ++i) {
            char c;
            short[] s2 = new short[8];
            int[] t2 = new int[5];
            int padlen = 8;
            for (int j = 0; j < 8 && (c = (char)in[i * 8 + j]) != '8'; ++j) {
                s2[j] = (short)ALPHABET.indexOf(in[i * 8 + j]);
                if (s2[j] < 0) {
                    return null;
                }
                --padlen;
            }
            int blocklen = Base32.paddingToLen(padlen);
            if (blocklen < 0) {
                return null;
            }
            t2[0] = s2[0] << 3 | s2[1] >> 2;
            t2[1] = (s2[1] & 3) << 6 | s2[2] << 1 | s2[3] >> 4;
            t2[2] = (s2[3] & 0xF) << 4 | s2[4] >> 1 & 0xF;
            t2[3] = s2[4] << 7 | s2[5] << 2 | s2[6] >> 3;
            t2[4] = (s2[6] & 7) << 5 | s2[7];
            try {
                for (int j = 0; j < blocklen; ++j) {
                    ds.writeByte((byte)(t2[j] & 0xFF));
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String res = new String(bs.toByteArray(), StandardCharsets.UTF_8);
        return res;
    }

    public static String encode(String str) {
        byte[] b = str.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int i = 0; i < (b.length + 4) / 5; ++i) {
            short[] s2 = new short[5];
            int[] t2 = new int[8];
            int blocklen = 5;
            for (int j = 0; j < 5; ++j) {
                if (i * 5 + j < b.length) {
                    s2[j] = (short)(b[i * 5 + j] & 0xFF);
                    continue;
                }
                s2[j] = 0;
                --blocklen;
            }
            int padlen = Base32.lenToPadding(blocklen);
            t2[0] = (byte)(s2[0] >> 3 & 0x1F);
            t2[1] = (byte)((s2[0] & 7) << 2 | s2[1] >> 6 & 3);
            t2[2] = (byte)(s2[1] >> 1 & 0x1F);
            t2[3] = (byte)((s2[1] & 1) << 4 | s2[2] >> 4 & 0xF);
            t2[4] = (byte)((s2[2] & 0xF) << 1 | s2[3] >> 7 & 1);
            t2[5] = (byte)(s2[3] >> 2 & 0x1F);
            t2[6] = (byte)((s2[3] & 3) << 3 | s2[4] >> 5 & 7);
            t2[7] = (byte)(s2[4] & 0x1F);
            for (int j = 0; j < t2.length - padlen; ++j) {
                char c = ALPHABET.charAt(t2[j]);
                os.write(c);
            }
        }
        String res = new String(os.toByteArray(), StandardCharsets.UTF_8);
        return res;
    }

    private static int lenToPadding(int blocklen) {
        switch (blocklen) {
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private static int paddingToLen(int padlen) {
        switch (padlen) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }
}

