/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.StreamItem;

public class Demuxer
implements StreamItem.Fetcher {
    private static final Logger LOGGER = Logger.getLogger(Demuxer.class.getName());
    private final InputStream is;
    private byte[] buffer = new byte[8];
    private byte[] content = new byte[256];

    public Demuxer(InputStream is) {
        this.is = is;
    }

    @Override
    public StreamItem fetch() {
        try {
            int read;
            boolean error;
            int read2;
            int sum = 0;
            do {
                if ((read2 = this.is.read(this.buffer, sum, this.buffer.length - sum)) >= 0) continue;
                return null;
            } while ((sum += read2) < 8);
            assert (this.buffer.length == 8);
            int size = ByteBuffer.wrap(this.buffer).getInt(4);
            if (this.buffer[0] == 0 || this.buffer[0] == 1) {
                error = false;
            } else if (this.buffer[0] == 2) {
                error = true;
            } else {
                throw new IOException("Unparsable stream " + this.buffer[0]);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
            sum = 0;
            do {
                if ((read = this.is.read(this.content, 0, Math.min(size - sum, this.content.length))) < 0) {
                    return null;
                }
                bos.write(this.content, 0, read);
            } while ((sum += read) < size);
            return new StreamItem(ByteBuffer.wrap(bos.toByteArray()), error);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }
}

