/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbSystemPatchRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String patchId;

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).patchId(this.patchId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",patchId=").append(String.valueOf(this.patchId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbSystemPatchRequest)) {
            return false;
        }
        GetDbSystemPatchRequest other = (GetDbSystemPatchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.patchId, other.patchId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemPatchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemId = null;
        private String patchId = null;

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemPatchRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchId(o.getPatchId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemPatchRequest build() {
            GetDbSystemPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbSystemPatchRequest buildWithoutInvocationCallback() {
            GetDbSystemPatchRequest request = new GetDbSystemPatchRequest();
            request.dbSystemId = this.dbSystemId;
            request.patchId = this.patchId;
            return request;
        }
    }
}

