/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.File;
import java.util.Optional;
import org.netbeans.modules.payara.common.wizards.ServerWizardIterator;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersion;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.WizardDescriptor;

public class PayaraPlatformDetails {
    public static boolean isInstalledInDirectory(PayaraPlatformVersionAPI version, File payaraDir) {
        Optional<PayaraPlatformVersionAPI> serverDetails = PayaraPlatformDetails.getVersionFromInstallDirectory(payaraDir);
        return serverDetails.isPresent() && serverDetails.get().equals(version);
    }

    public static WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        return new ServerWizardIterator(PayaraPlatformVersion.getVersions());
    }

    public static Optional<PayaraPlatformVersionAPI> getVersionFromInstallDirectory(File payaraDir) {
        Optional<PayaraPlatformVersionAPI> serverDetails = Optional.empty();
        if (payaraDir == null) {
            return serverDetails;
        }
        return Optional.ofNullable(ServerUtils.getPlatformVersion((String)payaraDir.getAbsolutePath()));
    }
}

