/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteMenuView;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

final class FormToolBar {
    private FormDesigner formDesigner;
    private JToolBar toolbar;
    private JToggleButton selectionButton;
    private JToggleButton connectionButton;
    private JToggleButton paletteButton;
    private JLabel addLabel;
    private PaletteMenuView paletteMenuView;
    private Listener listener;

    public FormToolBar(FormDesigner designer, JToolBar toolbar) {
        this.formDesigner = designer;
        if (toolbar == null) {
            toolbar = new ToolBar();
        } else {
            Object tb = toolbar.getClientProperty(FormToolBar.class);
            if (tb instanceof FormToolBar) {
                FormToolBar prevFormToolBar = (FormToolBar)tb;
                toolbar.removeMouseListener(prevFormToolBar.listener);
                int i = toolbar.getComponentIndex(prevFormToolBar.selectionButton) - 1;
                if (i >= 0) {
                    while (i < toolbar.getComponentCount()) {
                        toolbar.remove(i);
                    }
                }
            }
        }
        this.toolbar = toolbar;
        toolbar.putClientProperty(FormToolBar.class, this);
        toolbar.putClientProperty("isPrimary", Boolean.TRUE);
        this.listener = new Listener();
        this.selectionButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/selection_mode.png", (boolean)true), false);
        this.selectionButton.addActionListener(this.listener);
        this.selectionButton.addMouseListener(this.listener);
        this.selectionButton.setToolTipText(FormUtils.getBundleString("CTL_SelectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.selectionButton, (String)"gui.about");
        this.selectionButton.setSelected(true);
        this.initButton(this.selectionButton);
        this.connectionButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/connection_mode.png", (boolean)true), false);
        this.connectionButton.addActionListener(this.listener);
        this.connectionButton.addMouseListener(this.listener);
        this.connectionButton.setToolTipText(FormUtils.getBundleString("CTL_ConnectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.connectionButton, (String)"gui.connecting.intro");
        this.initButton(this.connectionButton);
        this.paletteButton = new JToggleButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/form/resources/beansButton.gif"), false);
        this.paletteButton.addActionListener(this.listener);
        this.paletteButton.addMouseListener(this.listener);
        this.paletteButton.setToolTipText(FormUtils.getBundleString("CTL_BeansButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.paletteButton, (String)"gui.components.adding");
        this.initButton(this.paletteButton);
        this.addLabel = new JLabel();
        this.addLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        toolbar.addMouseListener(this.listener);
        this.connectionButton.getAccessibleContext().setAccessibleName(this.connectionButton.getToolTipText());
        this.selectionButton.getAccessibleContext().setAccessibleName(this.selectionButton.getToolTipText());
        this.paletteButton.getAccessibleContext().setAccessibleName(this.paletteButton.getToolTipText());
        this.connectionButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ConnectionMode"));
        this.selectionButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_SelectionMode"));
        this.paletteButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_AddMode"));
        JToolBar.Separator separator2 = new JToolBar.Separator();
        separator2.setOrientation(1);
        JToolBar.Separator separator3 = new JToolBar.Separator();
        separator3.setOrientation(1);
        TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
        JButton testButton = (JButton)testAction.getToolbarPresenter();
        testButton.addMouseListener(this.listener);
        this.initButton(testButton);
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(this.selectionButton);
        toolbar.add(this.connectionButton);
        toolbar.add(this.paletteButton);
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(testButton);
        toolbar.add(Box.createHorizontalStrut(4));
        toolbar.add(separator2);
        toolbar.add(Box.createHorizontalStrut(4));
        this.installDesignerActions();
        toolbar.add(Box.createHorizontalStrut(4));
        toolbar.add(separator3);
        toolbar.add(Box.createHorizontalStrut(4));
        this.installResizabilityActions();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.addLabel);
        if (!FormLoaderSettings.getInstance().isPaletteInToolBar()) {
            this.showPaletteButton(false);
        }
    }

    JToolBar getToolBar() {
        return this.toolbar;
    }

    void installDesignerActions() {
        Collection<Action> actions = this.formDesigner.getDesignerActions(true);
        for (Action action : actions) {
            JButton button = this.toolbar.add(action);
            this.initButton(button);
        }
    }

    void installResizabilityActions() {
        Action[] actions = this.formDesigner.getResizabilityActions();
        JToggleButton[] resButtons = new JToggleButton[2];
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            JToggleButton button = new JToggleButton();
            button.setAction(action);
            this.initButton(button);
            resButtons[i] = button;
            this.toolbar.add(button);
            this.toolbar.add(Box.createHorizontalStrut(2));
        }
    }

    private void initButton(AbstractButton button) {
        if (!"Windows".equals(UIManager.getLookAndFeel().getID()) || !(button instanceof JToggleButton)) {
            button.setBorderPainted(false);
        }
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
    }

    void updateDesignerMode(int mode) {
        this.selectionButton.setSelected(mode == 0);
        this.connectionButton.setSelected(mode == 1);
        this.paletteButton.setSelected(mode == 2);
        if (this.addLabel.isVisible()) {
            PaletteItem item = PaletteUtils.getSelectedItem();
            if (item != null && mode == 2) {
                this.addLabel.setIcon(ImageUtilities.image2Icon((Image)item.getNode().getIcon(1)));
                this.addLabel.setText(item.getNode().getDisplayName());
            } else {
                this.addLabel.setText("");
                this.addLabel.setIcon(null);
            }
        }
    }

    void showPaletteButton(boolean visible) {
        this.addLabel.setVisible(visible);
        this.paletteButton.setVisible(visible);
        if ("Nimbus".equals(UIManager.getLookAndFeel().getID())) {
            if (visible) {
                this.addLabel.setPreferredSize(null);
                this.paletteButton.setPreferredSize(null);
            } else {
                this.addLabel.setPreferredSize(new Dimension());
                this.paletteButton.setPreferredSize(new Dimension());
            }
        }
    }

    private void showPaletteViewMenu() {
        if (this.paletteMenuView == null) {
            this.paletteMenuView = new PaletteMenuView(this.listener);
            this.paletteMenuView.getPopupMenu().addPopupMenuListener(this.listener);
        }
        Point p = this.paletteButton.getLocation();
        p.y += this.paletteButton.getHeight() + 2;
        this.paletteMenuView.getPopupMenu().show(this.toolbar, p.x, p.y);
    }

    private void showVisibilityPopupMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem(FormUtils.getBundleString("CTL_PaletteButton_MenuItem"));
        item.setSelected(FormLoaderSettings.getInstance().isPaletteInToolBar());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormLoaderSettings.getInstance().setPaletteInToolBar(item.isSelected());
            }
        });
        menu.add(item);
        menu.show(this.toolbar, p.x, p.y);
    }

    private static class ToolBar
    extends JToolBar {
        ToolBar() {
            super("editorToolbar");
            this.setFloatable(false);
            this.setRollover(true);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(Box.createHorizontalStrut(4));
            this.addSeparator();
        }

        @Override
        public String getUIClassID() {
            if (UIManager.get("Nb.Toolbar.ui") != null) {
                return "Nb.Toolbar.ui";
            }
            return super.getUIClassID();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    NodeAcceptor,
    PopupMenuListener {
        private boolean showMenu;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() == FormToolBar.this.selectionButton) {
                FormToolBar.this.formDesigner.toggleSelectionMode();
            } else if (ev.getSource() == FormToolBar.this.connectionButton) {
                FormToolBar.this.formDesigner.toggleConnectionMode();
            } else if (ev.getSource() == FormToolBar.this.paletteButton) {
                if (this.showMenu) {
                    FormToolBar.this.formDesigner.toggleAddMode();
                    FormToolBar.this.showPaletteViewMenu();
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    FormToolBar.this.formDesigner.toggleSelectionMode();
                }
            }
        }

        public boolean acceptNodes(Node[] nodes) {
            if (nodes.length == 0) {
                return false;
            }
            PaletteItem item = (PaletteItem)nodes[0].getCookie(PaletteItem.class);
            PaletteUtils.selectItem(item);
            return true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (PaletteUtils.getSelectedItem() == null) {
                FormToolBar.this.formDesigner.toggleSelectionMode();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == FormToolBar.this.paletteButton) {
                this.showMenu = !FormToolBar.this.paletteButton.isSelected();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && FormToolBar.this.formDesigner.getDesignerMode() == 0) {
                FormToolBar.this.showVisibilityPopupMenu(e.getPoint());
            }
        }
    }
}

