/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstancePoolInstanceLoadBalancerBackend;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstancePoolInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instancePoolId")
    private final String instancePoolId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="instanceConfigurationId")
    private final String instanceConfigurationId;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="state")
    private final String state;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="loadBalancerBackends")
    private final List<InstancePoolInstanceLoadBalancerBackend> loadBalancerBackends;

    @Deprecated
    @ConstructorProperties(value={"id", "instancePoolId", "availabilityDomain", "lifecycleState", "compartmentId", "displayName", "faultDomain", "instanceConfigurationId", "region", "shape", "state", "timeCreated", "loadBalancerBackends"})
    public InstancePoolInstance(String id, String instancePoolId, String availabilityDomain, LifecycleState lifecycleState, String compartmentId, String displayName, String faultDomain, String instanceConfigurationId, String region, String shape, String state, Date timeCreated, List<InstancePoolInstanceLoadBalancerBackend> loadBalancerBackends) {
        this.id = id;
        this.instancePoolId = instancePoolId;
        this.availabilityDomain = availabilityDomain;
        this.lifecycleState = lifecycleState;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.faultDomain = faultDomain;
        this.instanceConfigurationId = instanceConfigurationId;
        this.region = region;
        this.shape = shape;
        this.state = state;
        this.timeCreated = timeCreated;
        this.loadBalancerBackends = loadBalancerBackends;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getShape() {
        return this.shape;
    }

    public String getState() {
        return this.state;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public List<InstancePoolInstanceLoadBalancerBackend> getLoadBalancerBackends() {
        return this.loadBalancerBackends;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstancePoolInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", instancePoolId=").append(String.valueOf(this.instancePoolId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", loadBalancerBackends=").append(String.valueOf(this.loadBalancerBackends));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstancePoolInstance)) {
            return false;
        }
        InstancePoolInstance other = (InstancePoolInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.instancePoolId, other.instancePoolId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && Objects.equals(this.region, other.region) && Objects.equals(this.shape, other.shape) && Objects.equals(this.state, other.state) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.loadBalancerBackends, other.loadBalancerBackends) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instancePoolId == null ? 43 : this.instancePoolId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.loadBalancerBackends == null ? 43 : this.loadBalancerBackends.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Attaching("ATTACHING"),
        Active("ACTIVE"),
        Detaching("DETACHING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instancePoolId")
        private String instancePoolId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="instanceConfigurationId")
        private String instanceConfigurationId;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="state")
        private String state;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="loadBalancerBackends")
        private List<InstancePoolInstanceLoadBalancerBackend> loadBalancerBackends;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            this.__explicitlySet__.add("instancePoolId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            this.__explicitlySet__.add("instanceConfigurationId");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder loadBalancerBackends(List<InstancePoolInstanceLoadBalancerBackend> loadBalancerBackends) {
            this.loadBalancerBackends = loadBalancerBackends;
            this.__explicitlySet__.add("loadBalancerBackends");
            return this;
        }

        public InstancePoolInstance build() {
            InstancePoolInstance model = new InstancePoolInstance(this.id, this.instancePoolId, this.availabilityDomain, this.lifecycleState, this.compartmentId, this.displayName, this.faultDomain, this.instanceConfigurationId, this.region, this.shape, this.state, this.timeCreated, this.loadBalancerBackends);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstancePoolInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instancePoolId")) {
                this.instancePoolId(model.getInstancePoolId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("instanceConfigurationId")) {
                this.instanceConfigurationId(model.getInstanceConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("loadBalancerBackends")) {
                this.loadBalancerBackends(model.getLoadBalancerBackends());
            }
            return this;
        }
    }
}

