/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdatePublicIpDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePublicIpRequest
extends BmcRequest<UpdatePublicIpDetails> {
    private String publicIpId;
    private UpdatePublicIpDetails updatePublicIpDetails;
    private String ifMatch;

    public String getPublicIpId() {
        return this.publicIpId;
    }

    public UpdatePublicIpDetails getUpdatePublicIpDetails() {
        return this.updatePublicIpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePublicIpDetails getBody$() {
        return this.updatePublicIpDetails;
    }

    public Builder toBuilder() {
        return new Builder().publicIpId(this.publicIpId).updatePublicIpDetails(this.updatePublicIpDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",publicIpId=").append(String.valueOf(this.publicIpId));
        sb.append(",updatePublicIpDetails=").append(String.valueOf((Object)this.updatePublicIpDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePublicIpRequest)) {
            return false;
        }
        UpdatePublicIpRequest other = (UpdatePublicIpRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.publicIpId, other.publicIpId) && Objects.equals((Object)this.updatePublicIpDetails, (Object)other.updatePublicIpDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.publicIpId == null ? 43 : this.publicIpId.hashCode());
        result = result * 59 + (this.updatePublicIpDetails == null ? 43 : this.updatePublicIpDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePublicIpRequest, UpdatePublicIpDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String publicIpId = null;
        private UpdatePublicIpDetails updatePublicIpDetails = null;
        private String ifMatch = null;

        public Builder publicIpId(String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        public Builder updatePublicIpDetails(UpdatePublicIpDetails updatePublicIpDetails) {
            this.updatePublicIpDetails = updatePublicIpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePublicIpRequest o) {
            this.publicIpId(o.getPublicIpId());
            this.updatePublicIpDetails(o.getUpdatePublicIpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePublicIpRequest build() {
            UpdatePublicIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePublicIpDetails body) {
            this.updatePublicIpDetails(body);
            return this;
        }

        public UpdatePublicIpRequest buildWithoutInvocationCallback() {
            UpdatePublicIpRequest request = new UpdatePublicIpRequest();
            request.publicIpId = this.publicIpId;
            request.updatePublicIpDetails = this.updatePublicIpDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

