/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.ui.checklist.CheckList;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class TypesPanel
extends JPanel {
    private CheckList lstTypes;
    private List<? extends ScannerDescriptor> providers;
    private boolean[] providerState;
    private TypesFilter filter;
    private JButton btnOptions;
    private JLabel lblVisibleLimit;
    private JScrollPane scrollTypes;
    private JTextField txtVisibleLimit;

    public TypesPanel(TypesFilter filter) {
        this.filter = filter;
        this.init();
        if ("Metal".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    public boolean isValueValid() {
        return this.checkVisibleLimit();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var3_5;
        this.initComponents();
        this.providers = ScannerDescriptor.getDescriptors();
        ArrayList<ScannerDescriptor> toRemove = new ArrayList<ScannerDescriptor>();
        for (ScannerDescriptor scannerDescriptor : this.providers) {
            if (scannerDescriptor.getDisplayName() != null && !scannerDescriptor.getDisplayName().isEmpty()) continue;
            this.filter.setEnabled(scannerDescriptor.getType(), false);
            toRemove.add(scannerDescriptor);
        }
        this.providers.removeAll(toRemove);
        this.providerState = new boolean[this.providers.size()];
        Object[] names = new String[this.providers.size()];
        boolean bl = false;
        while (var3_5 < names.length) {
            names[var3_5] = this.providers.get((int)var3_5).getDisplayName();
            ++var3_5;
        }
        String[] stringArray = new String[this.providers.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.providers.get(i).getDescription();
        }
        this.lstTypes = new CheckList(this.providerState, names, stringArray);
        this.lstTypes.setSelectionMode(0);
        this.lstTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selIndex = TypesPanel.this.lstTypes.getSelectedIndex();
                boolean enableOptions = false;
                if (selIndex >= 0) {
                    ScannerDescriptor tp = (ScannerDescriptor)TypesPanel.this.providers.get(selIndex);
                    enableOptions = null != tp.getOptionsPath();
                }
                TypesPanel.this.btnOptions.setEnabled(enableOptions);
            }
        });
        this.lstTypes.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent arg0) {
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
            }

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                TypesPanel.this.putClientProperty("value-valid", TypesPanel.this.isValueValid());
            }
        });
        this.btnOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScannerDescriptor tp;
                int selIndex = TypesPanel.this.lstTypes.getSelectedIndex();
                if (selIndex >= 0 && null != (tp = (ScannerDescriptor)TypesPanel.this.providers.get(selIndex)).getOptionsPath()) {
                    OptionsDisplayer.getDefault().open(tp.getOptionsPath());
                }
            }
        });
        this.scrollTypes.setViewportView(this.lstTypes);
        this.showFilter(this.filter);
    }

    private void showFilter(TypesFilter filter) {
        for (int i = 0; i < this.providerState.length; ++i) {
            ScannerDescriptor tp = this.providers.get(i);
            this.providerState[i] = null != filter && filter.isEnabled(tp.getType());
        }
        this.txtVisibleLimit.setText(null == filter ? "" : String.valueOf(filter.getTaskCountLimit()));
        this.lstTypes.setEnabled(null != filter);
        this.txtVisibleLimit.setEnabled(null != filter);
    }

    private void initComponents() {
        this.lblVisibleLimit = new JLabel();
        this.txtVisibleLimit = new JTextField();
        this.btnOptions = new JButton();
        this.scrollTypes = new JScrollPane();
        this.setOpaque(false);
        this.lblVisibleLimit.setLabelFor(this.txtVisibleLimit);
        Mnemonics.setLocalizedText((JLabel)this.lblVisibleLimit, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.lblVisibleLimit.text"));
        this.txtVisibleLimit.setText(NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.txtVisibleLimit.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.btnOptions.text"));
        this.btnOptions.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollTypes, -1, 367, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOptions)).addGroup(layout.createSequentialGroup().addComponent(this.lblVisibleLimit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtVisibleLimit, -2, 49, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnOptions).addGroup(layout.createSequentialGroup().addComponent(this.scrollTypes, -1, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVisibleLimit).addComponent(this.txtVisibleLimit, -2, -1, -2)))).addContainerGap()));
    }

    public TypesFilter getFilter() {
        if (this.filter != null) {
            for (int i = 0; i < this.providerState.length; ++i) {
                ScannerDescriptor tp = this.providers.get(i);
                this.filter.setEnabled(tp.getType(), this.providerState[i]);
            }
            this.filter.setTaskCountLimit(this.getVisibleLimit());
        }
        return this.filter;
    }

    private int getVisibleLimit() {
        int limit = null == this.filter ? 100 : this.filter.getTaskCountLimit();
        try {
            String strLimit = this.txtVisibleLimit.getText();
            int tmp = Integer.parseInt(strLimit);
            if (tmp > 0) {
                limit = tmp;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return limit;
    }

    private boolean checkVisibleLimit() {
        try {
            String strLimit = this.txtVisibleLimit.getText();
            int limit = Integer.parseInt(strLimit);
            return limit > 0;
        }
        catch (NumberFormatException nfE) {
            return false;
        }
    }
}

