/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring;

import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.refactoring.Bundle;
import org.netbeans.modules.lsp.client.bindings.refactoring.RenameRefactoringUIImpl;
import org.netbeans.modules.lsp.client.bindings.refactoring.WhereUsedRefactoringUIImpl;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doFindUsages(Lookup lookup) {
        Runnable start = () -> {
            EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
            if (RefactoringActionsProvider.isFromEditor(ec)) {
                try {
                    JEditorPane c = ec.getOpenedPanes()[0];
                    Document doc = c.getDocument();
                    AbstractDocument abstractDoc = doc instanceof AbstractDocument ? (AbstractDocument)doc : null;
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    LSPBindings bindings = LSPBindings.getBindings(file);
                    Caret caret = c.getCaret();
                    if (caret == null) {
                        return;
                    }
                    int caretPos = caret.getDot();
                    Position pos = Utils.createPosition(doc, caretPos);
                    ReferenceParams params = new ReferenceParams();
                    params.setTextDocument(new TextDocumentIdentifier(Utils.toURI(file)));
                    params.setPosition(pos);
                    params.setContext(new ReferenceContext(false));
                    String name = Bundle.NM_Unknown();
                    if (abstractDoc != null) {
                        abstractDoc.readLock();
                    }
                    try {
                        TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
                        if (ts != null) {
                            ts.move(caretPos);
                            if (ts.moveNext()) {
                                name = ts.token().text().toString();
                            }
                        }
                    }
                    finally {
                        if (abstractDoc != null) {
                            abstractDoc.readUnlock();
                        }
                    }
                    UI.openRefactoringUI((RefactoringUI)new WhereUsedRefactoringUIImpl(bindings, params, name), (TopComponent)TopComponent.getRegistry().getActivated());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(start);
    }

    public void doRename(Lookup lookup) {
        Runnable start = () -> {
            EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
            if (RefactoringActionsProvider.isFromEditor(ec)) {
                try {
                    String name;
                    JEditorPane c = ec.getOpenedPanes()[0];
                    Document doc = c.getDocument();
                    AbstractDocument abstractDoc = doc instanceof AbstractDocument ? (AbstractDocument)doc : null;
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    LSPBindings bindings = LSPBindings.getBindings(file);
                    Caret caret = c.getCaret();
                    if (caret == null) {
                        return;
                    }
                    int caretPos = caret.getDot();
                    Position pos = Utils.createPosition(doc, caretPos);
                    if (abstractDoc != null) {
                        abstractDoc.readLock();
                    }
                    try {
                        TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
                        name = "";
                        if (ts != null) {
                            ts.move(caretPos);
                            if (ts.moveNext()) {
                                name = ts.token().text().toString();
                            }
                        }
                    }
                    finally {
                        if (abstractDoc != null) {
                            abstractDoc.readUnlock();
                        }
                    }
                    UI.openRefactoringUI((RefactoringUI)new RenameRefactoringUIImpl(bindings, file, pos, name), (TopComponent)TopComponent.getRegistry().getActivated());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(start);
    }

    static String getActionName(Action action) {
        String arg = (String)action.getValue("Name");
        arg = arg.replace("&", "");
        return arg.replace("...", "");
    }

    public boolean canFindUsages(Lookup lookup) {
        LSPBindings bindings = this.getBindings(lookup);
        if (bindings == null) {
            return false;
        }
        return Utils.isEnabled(bindings.getInitResult().getCapabilities().getReferencesProvider());
    }

    public boolean canRename(Lookup lookup) {
        LSPBindings bindings = this.getBindings(lookup);
        if (bindings == null) {
            return false;
        }
        Either<Boolean, RenameOptions> hasRename = bindings.getInitResult().getCapabilities().getRenameProvider();
        return hasRename != null && (hasRename.isLeft() && Utils.isTrue((Boolean)hasRename.getLeft()) || hasRename.isRight());
    }

    private LSPBindings getBindings(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringActionsProvider.isFromEditor(ec)) {
            JEditorPane c = ec.getOpenedPanes()[0];
            Document doc = c.getDocument();
            FileObject file = NbEditorUtilities.getFileObject((Document)doc);
            LSPBindings bindings = file != null ? LSPBindings.getBindings(file) : null;
            return bindings;
        }
        return null;
    }

    public static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && NbDocument.findRecentEditorPane((EditorCookie)ec) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }
}

