/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelAccess;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.util.RequestProcessor;

public abstract class AbstractModel<T extends Component<T>>
implements Model<T>,
UndoableEditListener {
    private static Logger logger = Logger.getLogger(AbstractModel.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(AbstractModel.class.getName(), 3, true);
    private PropertyChangeSupport pcs;
    protected ModelUndoableEditSupport ues;
    private Model.State status;
    private boolean inSync;
    private boolean inUndoRedo;
    private EventListenerList componentListeners;
    private Transaction transaction;
    private ModelSource source;
    private UndoableEditListener[] savedUndoableEditListeners;

    public AbstractModel(ModelSource source) {
        this.source = source;
        this.pcs = new PropertyChangeSupport(this);
        this.ues = new ModelUndoableEditSupport();
        this.componentListeners = new EventListenerList();
        this.status = Model.State.VALID;
    }

    public abstract ModelAccess getAccess();

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent event) {
        assert (this.transaction != null);
        this.transaction.addPropertyChangeEvent(event);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener uel) {
        this.ues.removeUndoableEditListener(uel);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener uel) {
        this.ues.addUndoableEditListener(uel);
    }

    @Override
    public synchronized void addUndoableRefactorListener(UndoableEditListener uel) {
        this.savedUndoableEditListeners = this.ues.getUndoableEditListeners();
        if (this.savedUndoableEditListeners != null) {
            for (UndoableEditListener saved : this.savedUndoableEditListeners) {
                if (!(saved instanceof UndoManager)) continue;
                ((UndoManager)saved).discardAllEdits();
            }
        }
        this.ues = new ModelUndoableEditSupport();
        this.ues.addUndoableEditListener(uel);
    }

    @Override
    public synchronized void removeUndoableRefactorListener(UndoableEditListener uel) {
        this.ues.removeUndoableEditListener(uel);
        if (this.savedUndoableEditListeners != null) {
            this.ues = new ModelUndoableEditSupport();
            for (UndoableEditListener saved : this.savedUndoableEditListeners) {
                this.ues.addUndoableEditListener(saved);
            }
            this.savedUndoableEditListeners = null;
        }
    }

    protected CompoundEdit createModelUndoableEdit() {
        return new ModelUndoableEdit();
    }

    @Override
    public boolean inSync() {
        return this.inSync;
    }

    protected void setInSync(boolean v) {
        this.inSync = v;
    }

    public boolean inUndoRedo() {
        return this.inUndoRedo;
    }

    protected void setInUndoRedo(boolean v) {
        this.inUndoRedo = v;
    }

    @Override
    public Model.State getState() {
        return this.status;
    }

    protected void setState(Model.State s) {
        if (s == this.status) {
            return;
        }
        Model.State old = this.status;
        this.status = s;
        PropertyChangeEvent event = new PropertyChangeEvent(this, "state", (Object)old, (Object)this.status);
        if (this.isIntransaction()) {
            this.firePropertyChangeEvent(event);
        } else {
            this.pcs.firePropertyChange(event);
        }
    }

    protected boolean needsSync() {
        return true;
    }

    protected void transactionStarted() {
    }

    protected void transactionCompleted() {
    }

    protected void syncStarted() {
    }

    protected void syncCompleted() {
    }

    private void prepareSync() {
        if (this.needsSync()) {
            this.getAccess().prepareSync();
        }
    }

    @Override
    public synchronized void sync() throws IOException {
        if (this.needsSync()) {
            this.syncStarted();
            boolean syncStartedTransaction = false;
            boolean success = false;
            try {
                this.startTransaction(true, false);
                syncStartedTransaction = true;
                this.setState(this.getAccess().sync());
                this.endTransaction();
                success = true;
            }
            catch (IOException e) {
                this.setState(Model.State.NOT_WELL_FORMED);
                this.endTransaction(false);
                throw e;
            }
            finally {
                if (syncStartedTransaction && this.isIntransaction()) {
                    try {
                        this.endTransaction(true);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Sync cleanup error.", ex);
                    }
                }
                if (!success && this.getState() != Model.State.NOT_WELL_FORMED) {
                    this.setState(Model.State.NOT_SYNCED);
                    this.refresh();
                }
                this.setInSync(false);
                this.syncCompleted();
            }
        }
    }

    protected void refresh() {
        this.setState(Model.State.VALID);
    }

    @Override
    public void removeComponentListener(ComponentListener cl) {
        this.componentListeners.remove(ComponentListener.class, cl);
    }

    @Override
    public void addComponentListener(ComponentListener cl) {
        this.componentListeners.add(ComponentListener.class, cl);
    }

    public void fireComponentChangedEvent(ComponentEvent evt) {
        assert (this.transaction != null);
        this.transaction.addComponentEvent(evt);
    }

    @Override
    public boolean isIntransaction() {
        return this.transaction != null;
    }

    @Override
    public synchronized void endTransaction() throws IllegalStateException {
        this.endTransaction(false);
    }

    protected synchronized void endTransaction(boolean quiet) {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.currentThreadIsTransactionThread()) {
            return;
        }
        try {
            if (!quiet) {
                this.transaction.fireEvents();
            }
            if (!this.inSync() && this.transaction.hasEvents() || this.transaction.hasEventsAfterFiring()) {
                this.getAccess().flush();
            }
            if (!this.inUndoRedo()) {
                this.ues.endUpdate();
            }
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.notifyAll();
            this.transactionCompleted();
        }
    }

    @Override
    @CheckReturnValue
    public boolean startTransaction() {
        return this.startTransaction(false, false);
    }

    private synchronized boolean startTransaction(boolean inSync, boolean inUndoRedo) {
        if (this.transaction != null && this.transaction.currentThreadIsTransactionThread()) {
            throw new IllegalStateException("Current thread has already started a transaction");
        }
        if (!inSync && !this.getModelSource().isEditable()) {
            throw new IllegalArgumentException("Model source is read-only.");
        }
        while (this.transaction != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!inSync && this.getState() == Model.State.NOT_WELL_FORMED) {
            this.notifyAll();
            return false;
        }
        this.transaction = new Transaction();
        this.transactionStarted();
        this.setInSync(inSync);
        this.setInUndoRedo(inUndoRedo);
        if (!inUndoRedo) {
            this.ues.beginUpdate();
        }
        return true;
    }

    public synchronized void rollbackTransaction() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.currentThreadIsTransactionThread()) {
            return;
        }
        try {
            if (this.inSync() || this.inUndoRedo()) {
                throw new IllegalArgumentException("Should never call rollback during sync or undo/redo.");
            }
            this.ues.abortUpdate();
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.notifyAll();
            this.transactionCompleted();
        }
    }

    protected synchronized void finishTransaction() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.currentThreadIsTransactionThread()) {
            return;
        }
        try {
            if (this.inSync() || this.inUndoRedo()) {
                throw new IllegalArgumentException("Should never call rollback during sync or undo/redo.");
            }
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.notifyAll();
            this.transactionCompleted();
        }
    }

    public synchronized void validateWrite() {
        if (this.transaction == null) {
            throw new IllegalStateException("attempted model write without invoking startTransaction");
        }
        if (!this.transaction.currentThreadIsTransactionThread()) {
            throw new IllegalStateException("attempted model write while a transaction is started by another thread");
        }
    }

    public boolean startedFiringEvents() {
        return this.transaction != null && this.transaction.eventsAddedAfterFiring != null;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.ues.postEdit(e.getEdit());
    }

    @Override
    public ModelSource getModelSource() {
        return this.source;
    }

    EventListenerList getComponentListenerList() {
        return this.componentListeners;
    }

    public boolean isAutoSyncActive() {
        return this.getAccess().isAutoSync();
    }

    public void setAutoSyncActive(boolean v) {
        this.getAccess().setAutoSync(v);
    }

    void runAutoSync() {
        if (logger.getLevel() == Level.FINEST) {
            logger.finest("Initiate auto sync for XAM model: " + this.toString());
        }
        this.prepareSync();
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractModel.this.sync();
                    if (logger.getLevel() == Level.FINEST) {
                        logger.finest("Auto sync is finished for XAM model: " + AbstractModel.this.toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected class ModelUndoableEditSupport
    extends UndoableEditSupport {
        protected ModelUndoableEditSupport() {
        }

        @Override
        protected CompoundEdit createCompoundEdit() {
            return AbstractModel.this.createModelUndoableEdit();
        }

        protected void abortUpdate() {
            ModelUndoableEdit mue = (ModelUndoableEdit)this.compoundEdit;
            mue.justUndo();
            this.compoundEdit = this.createCompoundEdit();
            this.updateLevel = 0;
        }
    }

    private class Transaction {
        private final List<PropertyChangeEvent> propertyChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final List<ComponentEvent> componentListenerEvents = new ArrayList<ComponentEvent>();
        private final Thread transactionThread = Thread.currentThread();
        private boolean eventAdded = false;
        private Boolean eventsAddedAfterFiring = null;
        private boolean hasEvents = false;

        public void addPropertyChangeEvent(PropertyChangeEvent pce) {
            this.propertyChangeEvents.add(pce);
            if (this.eventsAddedAfterFiring == null || !AbstractModel.this.inUndoRedo) {
                this.eventAdded = true;
            }
            if (this.eventsAddedAfterFiring != null) {
                this.eventsAddedAfterFiring = Boolean.TRUE;
            }
            this.hasEvents = true;
        }

        public void addComponentEvent(ComponentEvent cle) {
            this.componentListenerEvents.add(cle);
            if (this.eventsAddedAfterFiring == null || !AbstractModel.this.inUndoRedo) {
                this.eventAdded = true;
            }
            if (this.eventsAddedAfterFiring != null) {
                this.eventsAddedAfterFiring = Boolean.TRUE;
            }
            this.hasEvents = true;
        }

        public boolean currentThreadIsTransactionThread() {
            return Thread.currentThread().equals(this.transactionThread);
        }

        public void fireEvents() {
            if (this.eventsAddedAfterFiring == null) {
                this.eventsAddedAfterFiring = Boolean.FALSE;
            }
            while (this.eventAdded) {
                this.eventAdded = false;
                this.fireCompleteEventSet();
            }
        }

        private void fireCompleteEventSet() {
            ArrayList<PropertyChangeEvent> clonedEvents = new ArrayList<PropertyChangeEvent>(this.propertyChangeEvents);
            this.propertyChangeEvents.clear();
            for (PropertyChangeEvent pce : clonedEvents) {
                AbstractModel.this.pcs.firePropertyChange(pce);
            }
            ArrayList<ComponentEvent> cEvents = new ArrayList<ComponentEvent>(this.componentListenerEvents);
            this.componentListenerEvents.clear();
            HashMap<Object, Set<ComponentEvent.EventType>> fired = new HashMap<Object, Set<ComponentEvent.EventType>>();
            for (ComponentEvent cle : cEvents) {
                ComponentListener[] listeners;
                Set<ComponentEvent.EventType> types;
                Object source = cle.getSource();
                if (fired.containsKey(source)) {
                    types = (Set)fired.get(source);
                    if (types.contains((Object)cle.getEventType())) continue;
                    types.add(cle.getEventType());
                } else {
                    types = new HashSet();
                    types.add(cle.getEventType());
                    fired.put(cle.getSource(), types);
                }
                for (ComponentListener cl : listeners = (ComponentListener[])AbstractModel.this.componentListeners.getListeners(ComponentListener.class)) {
                    cle.getEventType().fireEvent(cle, cl);
                }
            }
        }

        public boolean hasEvents() {
            return this.hasEvents;
        }

        public boolean hasEventsAfterFiring() {
            return this.eventsAddedAfterFiring != null && this.eventsAddedAfterFiring != false;
        }
    }

    protected class ModelUndoableEdit
    extends CompoundEdit {
        static final long serialVersionUID = 1L;

        protected ModelUndoableEdit() {
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (!this.isInProgress()) {
                return false;
            }
            UndoableEdit last = this.lastEdit();
            if (last == null) {
                return super.addEdit(anEdit);
            }
            if (!last.addEdit(anEdit)) {
                return super.addEdit(anEdit);
            }
            return true;
        }

        @Override
        public void redo() throws CannotRedoException {
            boolean redoStartedTransaction = false;
            boolean needsRefresh = true;
            try {
                AbstractModel.this.startTransaction(true, true);
                redoStartedTransaction = true;
                AbstractModel.this.getAccess().prepareForUndoRedo();
                super.redo();
                AbstractModel.this.getAccess().finishUndoRedo();
                AbstractModel.this.endTransaction();
                needsRefresh = false;
            }
            catch (CannotRedoException ex) {
                needsRefresh = false;
                throw ex;
            }
            finally {
                if (AbstractModel.this.isIntransaction() && redoStartedTransaction) {
                    try {
                        AbstractModel.this.endTransaction(true);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Redo error", e);
                    }
                }
                if (needsRefresh) {
                    AbstractModel.this.setState(Model.State.NOT_SYNCED);
                    AbstractModel.this.refresh();
                }
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            boolean undoStartedTransaction = false;
            boolean needsRefresh = true;
            try {
                AbstractModel.this.startTransaction(true, true);
                undoStartedTransaction = true;
                AbstractModel.this.getAccess().prepareForUndoRedo();
                super.undo();
                AbstractModel.this.getAccess().finishUndoRedo();
                AbstractModel.this.endTransaction();
                needsRefresh = false;
            }
            catch (CannotUndoException ex) {
                needsRefresh = false;
                throw ex;
            }
            finally {
                if (undoStartedTransaction && AbstractModel.this.isIntransaction()) {
                    try {
                        AbstractModel.this.endTransaction(true);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Undo error", e);
                    }
                }
                if (needsRefresh) {
                    AbstractModel.this.setState(Model.State.NOT_SYNCED);
                    AbstractModel.this.refresh();
                }
            }
        }

        public void justUndo() {
            super.end();
            boolean oldValue = AbstractModel.this.inUndoRedo;
            AbstractModel.this.inUndoRedo = true;
            AbstractModel.this.getAccess().prepareForUndoRedo();
            super.undo();
            AbstractModel.this.getAccess().finishUndoRedo();
            AbstractModel.this.inUndoRedo = oldValue;
        }
    }
}

