/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;

class NetBeansRunSinglePlugin
implements Plugin<Project> {
    private static final GradleVersion GRADLE_VERSION = GradleVersion.current().getBaseVersion();
    private static final Logger LOG = Logging.getLogger(NetBeansRunSinglePlugin.class);
    private static final String RUN_SINGLE_TASK = "runSingle";
    private static final String RUN_SINGLE_MAIN = "runClassName";
    private static final String RUN_SINGLE_ARGS = "runArgs";
    private static final String RUN_SINGLE_JVM_ARGS = "runJvmArgs";
    private static final String RUN_SINGLE_CWD = "runWorkingDir";
    private static final String DEPRECATE_RUN_SINGLE = "runSingle task is deprecated. Inspect your configuration and use just 'run' task instead of 'runSingle'";

    NetBeansRunSinglePlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate(p -> {
            if (project.getPlugins().hasPlugin("java") && project.getTasks().findByPath(RUN_SINGLE_TASK) == null) {
                Set runTasks = p.getTasksByName("run", false);
                Task r = runTasks.isEmpty() ? null : (Task)runTasks.iterator().next();
                p.getTasks().withType(JavaExec.class).configureEach(je -> this.configureJavaExec(project, (JavaExec)je));
                this.addTask(project, r);
            }
        });
    }

    private void configureJavaExec(Project project, JavaExec je) {
        if (project.hasProperty(RUN_SINGLE_MAIN)) {
            String mainClass = project.property(RUN_SINGLE_MAIN).toString();
            if (GRADLE_VERSION.compareTo(GradleVersion.version((String)"6.4")) < 0) {
                je.setMain(mainClass);
            } else {
                je.getMainClass().set((Object)mainClass);
            }
        }
        if (project.hasProperty(RUN_SINGLE_ARGS)) {
            je.setArgs(Arrays.asList(project.property(RUN_SINGLE_ARGS).toString().split(" ")));
        }
        if (project.hasProperty(RUN_SINGLE_JVM_ARGS)) {
            je.getJvmArgumentProviders().add(new JvmArgumentsHolder(Arrays.asList(project.property(RUN_SINGLE_JVM_ARGS).toString().split(" "))));
        }
        try {
            je.setStandardInput(System.in);
        }
        catch (RuntimeException ex) {
            if (LOG.isEnabled(LogLevel.DEBUG)) {
                LOG.debug("Failed to set STDIN for Plugin: " + je.toString(), (Throwable)ex);
            }
            LOG.info("Failed to set STDIN for Plugin: " + je.toString());
        }
        if (project.hasProperty(RUN_SINGLE_CWD)) {
            je.setWorkingDir((Object)project.property(RUN_SINGLE_CWD).toString());
        }
    }

    private void addTask(Project project, Task runTask) {
        TaskProvider runSingle = runTask == null ? project.getTasks().register(RUN_SINGLE_TASK, JavaExec.class, je -> {
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
            je.setClasspath(((SourceSet)sourceSets.findByName("main")).getRuntimeClasspath());
            this.configureJavaExec(project, (JavaExec)je);
        }) : project.getTasks().register(RUN_SINGLE_TASK, DefaultTask.class, task -> task.finalizedBy(new Object[]{runTask}));
        runSingle.configure(task -> task.doFirst(action -> project.getLogger().warn(DEPRECATE_RUN_SINGLE)));
    }

    private static class JvmArgumentsHolder
    implements CommandLineArgumentProvider {
        private final List<String> jvmArguments;

        public JvmArgumentsHolder(List<String> jvmArguments) {
            this.jvmArguments = jvmArguments;
        }

        public Iterable<String> asArguments() {
            return this.jvmArguments;
        }
    }
}

