/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.j2ee.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.j2ee.support.SoapClientJ2eeOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class J2eeUtil {
    public static final String JSP_NAMES_PAGE = "page";

    public static boolean isRestJavaFile(DataObject d) {
        try {
            if (!JavaUtil.isJava((DataObject)d)) {
                return false;
            }
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return false;
            }
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                String docText = doc.getText(0, doc.getLength());
                return docText.indexOf("@Path") != -1 || docText.indexOf("@GET") != -1 || docText.indexOf("@POST") != -1 || docText.indexOf("@PUT") != -1 || docText.indexOf("@DELETE") != -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isServlet(DataObject d) {
        try {
            if (!JavaUtil.isJava((DataObject)d)) {
                return false;
            }
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return false;
            }
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                String docText = doc.getText(0, doc.getLength());
                return docText.indexOf("extends HttpServlet") != -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isJsp(DataObject d) {
        return d != null && "jsp".equals(d.getPrimaryFile().getExt());
    }

    public static void addServletMethod(SaasBean bean, String groupName, final String methodName, JavaSource source, final String[] parameters, final Object[] paramTypes, final String bodyText) throws IOException {
        if (JavaSourceHelper.isContainsMethod((JavaSource)source, (String)methodName, (String[])parameters, (Object[])paramTypes)) {
            return;
        }
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.RESOLVED);
                Modifier[] modifiers = JavaUtil.PROTECTED;
                String type = "void";
                String comment = "\n";
                for (String param : parameters) {
                    comment = comment + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", param);
                }
                comment = comment + "@return an instance of " + type;
                ClassTree initial = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                ClassTree tree = JavaSourceHelper.addMethod((WorkingCopy)copy, (ClassTree)initial, (Modifier[])modifiers, null, null, (String)methodName, (Object)type, (String[])parameters, (Object[])paramTypes, null, null, (Object[])new String[]{"javax.servlet.ServletException", "java.io.IOException"}, (String)bodyText, (String)comment);
                copy.rewrite((Tree)initial, (Tree)tree);
            }
        });
        result.commit();
    }

    public static void createSessionKeyAuthorizationClassesForWeb(SaasBean bean, Project project, String groupName, String saasServicePackageName, FileObject targetFolder, JavaSource loginJS, FileObject loginFile, JavaSource callbackJS, FileObject callbackFile, String[] parameters, Object[] paramTypes, boolean isUseTemplates, Constants.DropFileType dropFileType) throws IOException {
        FileObject[] loginFiles = new FileObject[1];
        JavaSource[] loginJavaSources = new JavaSource[]{};
        FileObject[] callbackFiles = new FileObject[1];
        JavaSource[] callbackJavaSources = new JavaSource[]{};
        J2eeUtil.createSessionKeyAuthorizationClassesForWeb(bean, project, groupName, saasServicePackageName, targetFolder, loginJavaSources, loginFiles, callbackJavaSources, callbackFiles, parameters, paramTypes, isUseTemplates, false, dropFileType);
        if (loginFiles[0] != null && callbackFiles[0] != null) {
            loginFile = loginFiles[0];
            callbackFile = callbackFiles[0];
            HashMap<String, String> filesMap = new HashMap<String, String>();
            filesMap.put(loginFile.getName(), saasServicePackageName + "." + loginFile.getName());
            filesMap.put(callbackFile.getName(), saasServicePackageName + "." + callbackFile.getName());
            J2eeUtil.addAuthorizationClassesToWebDescriptor(project, filesMap);
        } else {
            Logger.getLogger(J2eeUtil.class.getName()).log(Level.INFO, "Cannot add login and callback servletsto web descriptor");
        }
    }

    public static void createSessionKeyAuthorizationClassesForWeb(SaasBean bean, Project project, String groupName, String saasServicePackageName, FileObject targetFolder, JavaSource[] loginJS, FileObject[] loginFile, JavaSource[] callbackJS, FileObject[] callbackFile, String[] parameters, Object[] paramTypes, boolean isUseTemplates, boolean skipWebDescEntry, Constants.DropFileType dropFileType) throws IOException {
        Constants.SaasAuthenticationType authType = bean.getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SESSION_KEY || authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            if (!isUseTemplates) {
                String fileId = Util.upperFirstChar((String)"login");
                String methodName = "processRequest";
                String authFileName = groupName + fileId;
                loginJS[0] = JavaSourceHelper.createJavaSource((String)("Templates/SaaSServices/" + authType.getClassIdentifier() + fileId + "." + "java"), (FileObject)targetFolder, (String)saasServicePackageName, (String)authFileName);
                HashSet files = new HashSet(loginJS[0].getFileObjects());
                if (files != null && files.size() > 0) {
                    loginFile[0] = (FileObject)files.iterator().next();
                }
                if (!JavaSourceHelper.isContainsMethod((JavaSource)loginJS[0], (String)methodName, (String[])parameters, (Object[])paramTypes)) {
                    J2eeUtil.addServletMethod(bean, groupName, methodName, loginJS[0], parameters, paramTypes, "{ \n" + Util.getServletLoginBody((SaasBean)bean, (String)groupName) + "\n }");
                }
                fileId = Util.upperFirstChar((String)"callback");
                authFileName = groupName + fileId;
                callbackJS[0] = JavaSourceHelper.createJavaSource((String)("Templates/SaaSServices/" + authType.getClassIdentifier() + fileId + "." + "java"), (FileObject)targetFolder, (String)saasServicePackageName, (String)authFileName);
                files = new HashSet(callbackJS[0].getFileObjects());
                if (files != null && files.size() > 0) {
                    callbackFile[0] = (FileObject)files.iterator().next();
                }
                if (!JavaSourceHelper.isContainsMethod((JavaSource)callbackJS[0], (String)methodName, (String[])parameters, (Object[])paramTypes)) {
                    J2eeUtil.addServletMethod(bean, groupName, methodName, callbackJS[0], parameters, paramTypes, "{ \n" + Util.getServletCallbackBody((SaasBean)bean, (String)groupName) + "\n }");
                }
            } else {
                SaasBean.SaasAuthentication.UseTemplates useTemplates = null;
                if (bean.getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                    SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)bean.getAuthentication();
                    useTemplates = sessionKey.getUseTemplates();
                } else if (bean.getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                    SaasBean.HttpBasicAuthentication httpBasic = (SaasBean.HttpBasicAuthentication)bean.getAuthentication();
                    useTemplates = httpBasic.getUseTemplates();
                }
                if (useTemplates != null) {
                    String dropType = dropFileType.prefix();
                    for (SaasBean.SaasAuthentication.UseTemplates.Template template : useTemplates.getTemplates()) {
                        DataObject d;
                        if (!template.getDropTypeList().contains(dropType)) continue;
                        String id = template.getId();
                        String type = template.getType() == null ? "" : template.getType();
                        String templateUrl = template.getUrl();
                        if (templateUrl == null || templateUrl.trim().equals("")) {
                            throw new IOException("Authentication template is empty.");
                        }
                        if (templateUrl.contains("Desktop")) continue;
                        String fileName = null;
                        if (templateUrl.contains("Login")) {
                            fileName = bean.getSaasName() + Util.upperFirstChar((String)"login");
                        } else if (templateUrl.contains("Callback")) {
                            fileName = bean.getSaasName() + Util.upperFirstChar((String)"callback");
                        } else if (templateUrl.contains("Authenticator")) continue;
                        FileObject fObj = null;
                        if (templateUrl.endsWith(".java")) {
                            HashSet files;
                            JavaSource source = JavaSourceHelper.createJavaSource((String)templateUrl, (FileObject)targetFolder, (String)bean.getSaasServicePackageName(), (String)fileName);
                            if (source != null && J2eeUtil.getDeploymentDescriptor(project) == null) {
                                J2eeUtil.addServletAnnotation(source, fileName, "/" + fileName);
                            }
                            if ((files = new HashSet(source.getFileObjects())) != null && files.size() > 0) {
                                fObj = (FileObject)files.iterator().next();
                            }
                        } else if (fileName != null && (fObj = targetFolder.getFileObject(fileName)) == null && (d = Util.createDataObjectFromTemplate((String)templateUrl, (FileObject)targetFolder, (String)fileName)) != null) {
                            fObj = d.getPrimaryFile();
                        }
                        if (fObj == null) continue;
                        if (templateUrl.contains("Login")) {
                            loginFile[0] = fObj;
                            continue;
                        }
                        if (!templateUrl.contains("Callback")) continue;
                        callbackFile[0] = fObj;
                    }
                }
            }
        }
    }

    public static FileObject getWebXmlFile(Project p) {
        SourceGroup[] groups;
        for (SourceGroup group : groups = ProjectUtils.getSources((Project)p).getSourceGroups("web")) {
            FileObject root = group.getRootFolder();
            Enumeration files = root.getData(true);
            while (files.hasMoreElements()) {
                FileObject fobj = (FileObject)files.nextElement();
                if (!fobj.getNameExt().equals("web.xml")) continue;
                return fobj;
            }
        }
        return null;
    }

    public static void addAuthorizationClassesToWebDescriptor(Project p, Map<String, String> filesMap) throws IOException {
        for (Map.Entry<String, String> e : filesMap.entrySet()) {
            String name = e.getKey();
            String qName = e.getValue();
            J2eeUtil.addServiceEntriesToDD(p, name, qName);
        }
    }

    public static void addServiceEntriesToDD(Project p, String servletName, String servletClassName) {
        WebApp webApp = J2eeUtil.getWebApp(p);
        if (webApp != null) {
            Servlet servlet = null;
            Object listener = null;
            try {
                servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{servletName, servletClassName}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                ServletMapping servletMapping = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{servletName, "/" + servletName}, "ServletName");
                webApp.write(J2eeUtil.getDeploymentDescriptor(p));
            }
            catch (ClassNotFoundException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (NameAlreadyUsedException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (IOException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
        }
    }

    public static FileObject getDeploymentDescriptor(Project p) {
        FileObject webInfFo = J2eeUtil.getWebInf(p);
        if (webInfFo == null) {
            if (JavaUtil.isProjectOpened((Project)p)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CodeSetupPanel.class, (String)"MSG_WebInfCorrupted", (Object[])new Object[]{p.getProjectDirectory().getPath()}), 0));
            }
            return null;
        }
        return J2eeUtil.getWebInf(p).getFileObject("web.xml");
    }

    public static FileObject getWebInf(Project p) {
        WebModule webModule = J2eeUtil.getWebModule(p.getProjectDirectory());
        if (webModule != null) {
            return webModule.getWebInf();
        }
        return null;
    }

    public static WebApp getWebApp(Project p) {
        try {
            FileObject deploymentDescriptor = J2eeUtil.getDeploymentDescriptor(p);
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, e.getLocalizedMessage());
        }
        return null;
    }

    public static WebModule getWebModule(FileObject fo) {
        return J2eeUtil.getWebModule(fo, false);
    }

    public static WebModule getWebModule(FileObject fo, boolean checkParent) {
        FileObject wmRoot;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (checkParent && wm != null && (fo == (wmRoot = wm.getDocumentBase()) || FileUtil.isParentOf((FileObject)wmRoot, (FileObject)fo))) {
            return WebModule.getWebModule((FileObject)fo);
        }
        return wm;
    }

    public static String wrapWithTag(String content, Document doc, int insertStart) {
        boolean addTag;
        String str = "";
        boolean bl = addTag = !J2eeUtil.isWithinTag(doc, 0, insertStart);
        if (addTag) {
            str = str + "\n<%\n";
        }
        str = str + content;
        if (addTag) {
            str = str + "\n%>\n";
        }
        return str;
    }

    public static boolean isWithinTag(Document doc, int start, int end) {
        try {
            String str = doc.getText(start, end - start);
            return str.lastIndexOf("<%") > str.lastIndexOf("%>");
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    public static String getJspImports(Document doc, int start, String svcPkg) throws IOException {
        String[] imports = new String[]{"org.netbeans.saas.*", svcPkg + ".*"};
        ArrayList<String> importsToAdd = new ArrayList<String>();
        String code = "";
        List<String> existingImports = J2eeUtil.getExistingJspImports(NbEditorUtilities.getFileObject((Document)doc));
        for (String imp : imports) {
            if (existingImports.contains(imp)) continue;
            importsToAdd.add(imp);
        }
        if (importsToAdd.size() > 0) {
            code = code + "\n<%@ page import=\"";
        }
        for (String imp : importsToAdd) {
            code = code + imp + ", ";
        }
        if (importsToAdd.size() > 0) {
            code = code.substring(0, code.length() - 2) + "\" %>\n";
        }
        if (code.length() > 0 && J2eeUtil.isWithinTag(doc, 0, start)) {
            code = "%>\n" + code + "\n<%";
        }
        return code;
    }

    public static List<String> getExistingJspImports(FileObject fo) throws IOException {
        WebModule webModule = J2eeUtil.getWebModule(fo, true);
        JspParserAPI jspParser = JspParserFactory.getJspParser();
        JspParserAPI.ParseResult result = jspParser.analyzePage(fo, webModule, 1);
        PageInfo pInfo = result.getPageInfo();
        return pInfo.getImports();
    }

    public static List<ParameterInfo> filterJspParameters(List<ParameterInfo> params) {
        ArrayList<ParameterInfo> returnParams = new ArrayList<ParameterInfo>();
        for (ParameterInfo p : params) {
            String name = Util.getParameterName((ParameterInfo)p);
            if ("request".equals(name) || "response".equals(name)) continue;
            returnParams.add(p);
        }
        return returnParams;
    }

    public static SoapClientJ2eeOperationInfo[] toJaxwsOperationInfos(WsdlSaasMethod m, Project project) {
        ArrayList<SoapClientJ2eeOperationInfo> infos = new ArrayList<SoapClientJ2eeOperationInfo>();
        infos.add(new SoapClientJ2eeOperationInfo(m, project));
        return infos.toArray(new SoapClientJ2eeOperationInfo[0]);
    }

    public static void addServletAnnotation(JavaSource javaSource, final String servletName, final String urlPattern) throws IOException {
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement servletAn = workingCopy.getElements().getTypeElement("javax.servlet.annotation.WebServlet");
                if (servletAn != null) {
                    ClassTree classTree;
                    boolean found = false;
                    TypeElement classEl = J2eeUtil.getPublicTopLevelElement((CompilationController)workingCopy);
                    if (classEl != null) {
                        List<? extends AnnotationMirror> annotations = classEl.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : annotations) {
                            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                            if (!qualifiedName.contentEquals("javax.servlet.annotation.WebServlet")) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found && (classTree = J2eeUtil.getPublicTopLevelTree((CompilationController)workingCopy)) != null) {
                        TreeMaker make = workingCopy.getTreeMaker();
                        ArrayList<AssignmentTree> arrayList = new ArrayList<AssignmentTree>();
                        arrayList.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)servletName)));
                        arrayList.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)make.Literal((Object)urlPattern)));
                        AnnotationTree servletAnnotation = make.Annotation((Tree)make.QualIdent((Element)servletAn), arrayList);
                        ClassTree modifiedClass = make.Class(make.addModifiersAnnotation(classTree.getModifiers(), servletAnnotation), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), classTree.getPermitsClause(), classTree.getMembers());
                        workingCopy.rewrite((Tree)classTree, (Tree)modifiedClass);
                    }
                }
            }
        };
        javaSource.runModificationTask((Task)modificationTask).commit();
    }

    public static ClassTree getPublicTopLevelTree(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        TypeElement typeElement = J2eeUtil.getPublicTopLevelElement(controller);
        if (typeElement != null) {
            return controller.getTrees().getTree(typeElement);
        }
        return null;
    }

    public static TypeElement getPublicTopLevelElement(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        FileObject mainFileObject = controller.getFileObject();
        if (mainFileObject == null) {
            throw new IllegalStateException();
        }
        String mainElementName = mainFileObject.getName();
        List elements = controller.getTopLevelElements();
        if (elements != null) {
            for (TypeElement element : elements) {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getSimpleName().contentEquals(mainElementName)) continue;
                return element;
            }
        }
        return null;
    }
}

