/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsonParserResult;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class JsonSemanticAnalyzer
extends SemanticAnalyzer<JsonParserResult> {
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = Collections.emptyMap();
    private volatile boolean canceled = false;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void run(JsonParserResult result, SchedulerEvent event) {
        this.canceled = false;
        if (this.canceled) {
            return;
        }
        Map<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        Model model = Model.getModel((ParserResult)result, (boolean)false);
        highlights = this.count(result, model.getGlobalObject(), highlights, new HashSet<String>());
        assert (highlights != null);
        this.semanticHighlights = highlights;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> count(JsonParserResult result, JsObject parent, Map<OffsetRange, Set<ColoringAttributes>> highlights, Set<String> processedObjects) {
        if (ModelUtils.wasProcessed((JsObject)parent, processedObjects)) {
            return highlights;
        }
        for (JsObject object : parent.getProperties().values()) {
            JsReference jr;
            if (object.getDeclarationName() != null) {
                switch (object.getJSKind()) {
                    case OBJECT_LITERAL: {
                        if (object.getDeclarationName() == null) break;
                        this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                        break;
                    }
                    case PROPERTY: {
                        this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                    }
                }
            }
            if (this.canceled) {
                highlights = Collections.emptyMap();
                break;
            }
            if (object instanceof JsReference && ModelUtils.isDescendant((JsObject)object, (JsObject)(jr = (JsReference)object).getOriginal())) continue;
            highlights = this.count(result, object, highlights, processedObjects);
        }
        return highlights;
    }

    private void addColoring(JsonParserResult result, Map<OffsetRange, Set<ColoringAttributes>> highlights, OffsetRange astRange, Set<ColoringAttributes> coloring) {
        int start = result.getSnapshot().getOriginalOffset(astRange.getStart());
        int end = result.getSnapshot().getOriginalOffset(astRange.getEnd());
        if (start > -1 && end > -1 && start < end) {
            OffsetRange range = start == astRange.getStart() ? astRange : new OffsetRange(start, end);
            highlights.put(range, coloring);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.canceled = true;
    }
}

