/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class JsEmbeddingProvider
extends EmbeddingProvider {
    private static final int PRIORITY = 0;
    private static final String JS_MIMETYPE = "text/javascript";
    private static final String SCRIPT_TYPE_MODULE = "module";
    public static final String NETBEANS_IMPORT_FILE = "__netbeans_import__";
    private static final Logger LOG = Logger.getLogger(JsEmbeddingProvider.class.getName());
    private static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String TPL_MIME_TYPE = "text/x-tpl";
    private static final String TWIG_MIME_TYPE = "text/x-twig";
    private static final String LATTE_MIME_TYPE = "text/x-latte";
    private static final String JSX_MIME_TYPE = "text/x-jsx";
    private static final Map<String, Translator> translators = new HashMap<String, Translator>();
    private static final String GENERATED_IDENTIFIER = "__UNKNOWN__";
    private final String sourceMimeType;
    private final Translator translator;

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            List<Embedding> embeddings = this.translator.translate(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.log(Level.WARNING, "Unexpected snapshot type: ''{0}''; expecting ''{1}''", new Object[]{snapshot.getMimeType(), this.sourceMimeType});
        return Collections.emptyList();
    }

    public int getPriority() {
        return 0;
    }

    public void cancel() {
    }

    public static boolean isGeneratedIdentifier(String ident) {
        return GENERATED_IDENTIFIER.equals(ident) || ident.contains(NETBEANS_IMPORT_FILE);
    }

    public static boolean containsGeneratedIdentifier(String ident) {
        return ident.contains(GENERATED_IDENTIFIER) || ident.contains(NETBEANS_IMPORT_FILE);
    }

    private JsEmbeddingProvider(String sourceMimeType, Translator translator) {
        this.sourceMimeType = sourceMimeType;
        this.translator = translator;
    }

    private static void extractJavaScriptFromHtml(Snapshot snapshot, TokenSequence<? extends HTMLTokenId> ts, JsAnalyzerState state, List<Embedding> embeddings) {
        ts.moveStart();
        while (ts.moveNext()) {
            CharSequence value;
            Token htmlToken = ts.token();
            HTMLTokenId htmlId = (HTMLTokenId)htmlToken.id();
            if (htmlId == HTMLTokenId.SCRIPT) {
                String scriptType = (String)htmlToken.getProperty((Object)"type");
                if (scriptType != null && !JS_MIMETYPE.equals(scriptType) && !SCRIPT_TYPE_MODULE.equals(scriptType)) continue;
                state.in_javascript = true;
                int sourceStart = ts.offset();
                String text = htmlToken.text().toString();
                List<EmbeddingPosition> jsEmbeddings = JsEmbeddingProvider.extractJsEmbeddings(text, sourceStart);
                for (EmbeddingPosition embedding : jsEmbeddings) {
                    embeddings.add(snapshot.create(embedding.getOffset(), embedding.getLength(), JS_MIMETYPE));
                }
                continue;
            }
            if (htmlId == HTMLTokenId.TAG_OPEN) {
                Token t;
                HTMLTokenId id;
                String text = htmlToken.text().toString();
                if (!"script".equals(text)) continue;
                TokenSequence ets = ts.subSequence(ts.offset());
                ets.moveStart();
                boolean foundSrc = false;
                boolean foundType = false;
                String type = null;
                String src = null;
                while (ets.moveNext() && (id = (HTMLTokenId)(t = ets.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    if (foundSrc || foundType) {
                        if (id == HTMLTokenId.ARGUMENT) break;
                        if (id != HTMLTokenId.VALUE) continue;
                        if (foundSrc) {
                            src = t.toString();
                        } else {
                            assert (foundType);
                            type = t.toString();
                        }
                        foundSrc = false;
                        foundType = false;
                        continue;
                    }
                    if (id != HTMLTokenId.ARGUMENT) continue;
                    String val = t.toString();
                    if ("src".equals(val)) {
                        foundSrc = true;
                        continue;
                    }
                    if (!"type".equals(val)) continue;
                    foundType = true;
                }
                if (src == null || type != null && !type.toLowerCase().contains("javascript")) continue;
                if (src.length() > 2 && src.startsWith("\"") && src.endsWith("\"")) {
                    src = src.substring(1, src.length() - 1);
                }
                if (src.length() > 2 && src.startsWith("'") && src.endsWith("'")) {
                    src = src.substring(1, src.length() - 1);
                }
                String insertText = "__netbeans_import__('" + src + "');\n";
                embeddings.add(snapshot.create((CharSequence)insertText, JS_MIMETYPE));
                continue;
            }
            if (state.in_javascript && htmlId == HTMLTokenId.TEXT) {
                embeddings.add(snapshot.create(ts.offset(), htmlToken.length(), JS_MIMETYPE));
                continue;
            }
            if (htmlId == HTMLTokenId.VALUE_JAVASCRIPT) {
                int sourceStart = ts.offset();
                int sourceEnd = sourceStart + ts.token().length();
                if (!state.in_inlined_javascript) {
                    char fch;
                    value = htmlToken.text().toString();
                    if (((String)value).length() > 0 && ((fch = ((String)value).charAt(0)) == '\'' || fch == '\"')) {
                        state.opening_quotation_stripped = true;
                        ++sourceStart;
                    }
                    embeddings.add(snapshot.create((CharSequence)"(function(){\n", JS_MIMETYPE));
                }
                state.in_inlined_javascript = true;
                state.lastInlinedJavascriptToken = ts.token();
                state.lastInlinedJavscriptEmbedding = snapshot.create(sourceStart, sourceEnd - sourceStart, JS_MIMETYPE);
                embeddings.add(state.lastInlinedJavscriptEmbedding);
                ++state.inlined_javascript_pieces;
                continue;
            }
            if (state.in_inlined_javascript && htmlId != HTMLTokenId.VALUE_JAVASCRIPT) {
                char fch;
                assert (state.lastInlinedJavscriptEmbedding != null);
                assert (state.lastInlinedJavascriptToken != null);
                int sourceStart = state.lastInlinedJavascriptToken.offset(snapshot.getTokenHierarchy());
                int sourceLength = state.lastInlinedJavascriptToken.length();
                value = state.lastInlinedJavascriptToken.text();
                if (state.opening_quotation_stripped && value.length() > 0 && ((fch = value.charAt(value.length() - 1)) == '\'' || fch == '\"')) {
                    --sourceLength;
                    if (state.inlined_javascript_pieces == 1) {
                        ++sourceStart;
                        --sourceLength;
                    }
                    boolean removed = embeddings.remove(state.lastInlinedJavscriptEmbedding);
                    assert (removed);
                    embeddings.add(snapshot.create(sourceStart, sourceLength, JS_MIMETYPE));
                }
                state.in_inlined_javascript = false;
                state.opening_quotation_stripped = false;
                state.lastInlinedJavascriptToken = null;
                state.lastInlinedJavscriptEmbedding = null;
                state.inlined_javascript_pieces = 0;
                embeddings.add(snapshot.create((CharSequence)"\n});\n", JS_MIMETYPE));
                continue;
            }
            if (htmlId == HTMLTokenId.TAG_CLOSE && "script".equals(htmlToken.toString())) {
                embeddings.add(snapshot.create((CharSequence)"\n", JS_MIMETYPE));
                continue;
            }
            if (htmlId == HTMLTokenId.EL_OPEN_DELIMITER) {
                String mimetype = (String)ts.token().getProperty((Object)"contentMimeType");
                if (mimetype == null || !JS_MIMETYPE.equals(mimetype)) continue;
                embeddings.add(snapshot.create((CharSequence)"(function(){\n", JS_MIMETYPE));
                if (!ts.moveNext()) continue;
                Token token = ts.token();
                if (token.id() == HTMLTokenId.EL_CONTENT) {
                    embeddings.add(snapshot.create(ts.offset(), ts.token().length(), JS_MIMETYPE));
                    embeddings.add(snapshot.create((CharSequence)";\n});\n", JS_MIMETYPE));
                    continue;
                }
                if (token.id() != HTMLTokenId.EL_CLOSE_DELIMITER) continue;
                embeddings.add(snapshot.create(ts.offset(), 0, JS_MIMETYPE));
                embeddings.add(snapshot.create((CharSequence)";\n});\n", JS_MIMETYPE));
                continue;
            }
            state.in_javascript = false;
        }
    }

    protected static List<EmbeddingPosition> extractJsEmbeddings(String text, int sourceStart) {
        int lineEnd;
        char c;
        int start;
        LinkedList<EmbeddingPosition> embeddings = new LinkedList<EmbeddingPosition>();
        for (start = 0; start < text.length() && Character.isWhitespace(c = text.charAt(start)); ++start) {
        }
        if (start < text.length() && text.startsWith("<!--", start) && JsEmbeddingProvider.isHtmlCommentStartToSkip(text, start, lineEnd = text.indexOf(10, start))) {
            if (start > 0) {
                embeddings.add(new EmbeddingPosition(sourceStart, start));
            }
            sourceStart += ++lineEnd;
            text = text.substring(lineEnd);
        }
        Scanner scanner = new Scanner(text).useDelimiter("(<!--).*(-->)");
        while (scanner.hasNext()) {
            scanner.next();
            MatchResult match = scanner.match();
            embeddings.add(new EmbeddingPosition(sourceStart + match.start(), match.group().length()));
        }
        return embeddings;
    }

    private static boolean isHtmlCommentStartToSkip(String text, int start, int lineEnd) {
        if (lineEnd != -1) {
            if (text.startsWith("<!--//-->", start)) {
                return true;
            }
            return text.indexOf("-->", start) == -1 || lineEnd < text.indexOf("-->", start);
        }
        return false;
    }

    static {
        translators.put(RHTML_MIME_TYPE, new RhtmlTranslator());
        translators.put(TPL_MIME_TYPE, new TplTranslator());
        translators.put(TWIG_MIME_TYPE, new TwigTranslator());
        translators.put(LATTE_MIME_TYPE, new LatteTranslator());
        translators.put(JSX_MIME_TYPE, new JsxJsTranslator());
    }

    protected static interface Translator {
        public List<Embedding> translate(Snapshot var1);
    }

    private static final class JsAnalyzerState {
        int inlined_javascript_pieces = 0;
        boolean in_javascript = false;
        boolean in_inlined_javascript = false;
        boolean opening_quotation_stripped = false;
        Token<?> lastInlinedJavascriptToken = null;
        Embedding lastInlinedJavscriptEmbedding = null;

        private JsAnalyzerState() {
        }
    }

    protected static final class EmbeddingPosition {
        private final int offset;
        private final int length;

        public EmbeddingPosition(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static final class RhtmlTranslator
    implements Translator {
        private RhtmlTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.log(Level.INFO, "Cannot get TokenHierarchy from snapshot {0}", snapshot);
                return embeddings;
            }
            TokenSequence tokenSequence = th.tokenSequence();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().primaryCategory().equals("html")) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!token.id().primaryCategory().equals("ruby") || !state.in_inlined_javascript && !state.in_javascript) continue;
                int sourceStart = tokenSequence.offset();
                int sourceEnd = sourceStart + token.length();
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, JsEmbeddingProvider.JS_MIMETYPE));
            }
            return embeddings;
        }
    }

    protected static final class TplTranslator
    implements Translator {
        private static final String T_HTML = "T_HTML";
        private static final String T_SMARTY = "T_SMARTY";

        protected TplTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.log(Level.INFO, "Cannot get TokenHierarchy from snapshot {0}", snapshot);
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = th.tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                boolean hasNext;
                Token token = tokenSequence.token();
                if (token.id().name().equals(T_HTML)) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!state.in_inlined_javascript && !state.in_javascript) continue;
                boolean wasInTpl = false;
                boolean wasInLiteral = false;
                while (hasNext = tokenSequence.moveNext()) {
                    Token innerToken = tokenSequence.token();
                    if (CharSequenceUtilities.textEquals((CharSequence)"ldelim", (CharSequence)innerToken.text())) {
                        wasInLiteral = true;
                        embeddings.add(snapshot.create((CharSequence)"{", JsEmbeddingProvider.JS_MIMETYPE));
                        continue;
                    }
                    if (CharSequenceUtilities.textEquals((CharSequence)"rdelim", (CharSequence)innerToken.text())) {
                        wasInLiteral = true;
                        embeddings.add(snapshot.create((CharSequence)"}", JsEmbeddingProvider.JS_MIMETYPE));
                        continue;
                    }
                    if (innerToken.id().name().equals(T_HTML)) break;
                    wasInTpl = true;
                    if (CharSequenceUtilities.indexOf((CharSequence)innerToken.text(), (CharSequence)"literal") > -1) {
                        wasInLiteral = true;
                        continue;
                    }
                    if (!innerToken.id().name().equals(T_SMARTY) || !wasInLiteral) continue;
                    wasInLiteral = false;
                    embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, JsEmbeddingProvider.JS_MIMETYPE));
                }
                if (hasNext) {
                    tokenSequence.movePrevious();
                }
                if (!wasInTpl || wasInLiteral) continue;
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, JsEmbeddingProvider.JS_MIMETYPE));
            }
            return embeddings;
        }
    }

    private static final class TwigTranslator
    implements Translator {
        private TwigTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.log(Level.INFO, "Cannot get TokenHierarchy from snapshot {0}", snapshot);
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = th.tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().name().equals("T_HTML") || token.id().name().equals("T_TWIG_RAW")) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!token.id().name().equals("T_TWIG") || !state.in_inlined_javascript && !state.in_javascript) continue;
                boolean hasNext = false;
                while (token.id().name().equals("T_TWIG") && (hasNext = tokenSequence.moveNext())) {
                    token = tokenSequence.token();
                }
                if (hasNext) {
                    tokenSequence.movePrevious();
                }
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, JsEmbeddingProvider.JS_MIMETYPE));
            }
            return embeddings;
        }
    }

    private static final class LatteTranslator
    implements Translator {
        private LatteTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.log(Level.INFO, "Cannot get TokenHierarchy from snapshot {0}", snapshot);
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = th.tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().name().equals("T_HTML")) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!token.id().name().equals("T_LATTE") || !state.in_inlined_javascript && !state.in_javascript) continue;
                boolean hasNext = false;
                while (token.id().name().equals("T_LATTE") && (hasNext = tokenSequence.moveNext())) {
                    token = tokenSequence.token();
                }
                if (hasNext) {
                    tokenSequence.movePrevious();
                }
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, JsEmbeddingProvider.JS_MIMETYPE));
            }
            return embeddings;
        }
    }

    private static class JsxJsTranslator
    implements Translator {
        private static final int MAX_EMBEDDING_LENGTH = 5000000;
        public static final String GENERATED_CODE = "@@@";

        private JsxJsTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                return Collections.emptyList();
            }
            TokenSequence sequence = th.tokenSequence(JsTokenId.javascriptLanguage());
            sequence.moveStart();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            int from = -1;
            int len = 0;
            while (sequence.moveNext()) {
                Token t = sequence.token();
                if (t.id() == JsTokenId.JSX_TEXT) {
                    if (from < 0) {
                        from = sequence.offset();
                    }
                    len += t.length();
                    continue;
                }
                if (from >= 0) {
                    JsxJsTranslator.createHtmlEmbedding(embeddings, snapshot, from, len);
                    embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, JsEmbeddingProvider.HTML_MIME_TYPE));
                }
                from = -1;
                len = 0;
            }
            if (from >= 0) {
                JsxJsTranslator.createHtmlEmbedding(embeddings, snapshot, from, len);
            }
            if (!embeddings.isEmpty()) {
                return Collections.singletonList(Embedding.create(embeddings));
            }
            return Collections.emptyList();
        }

        private static void createHtmlEmbedding(List<Embedding> embeddings, Snapshot snapshot, int from, int length) {
            assert (embeddings != null);
            assert (snapshot != null);
            if (length <= 5000000) {
                embeddings.add(snapshot.create(from, length, JsEmbeddingProvider.HTML_MIME_TYPE));
            }
        }
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (snapshot.getMimeType().equals(JsEmbeddingProvider.HTML_MIME_TYPE) && snapshot.getMimePath().size() > 1) {
                return null;
            }
            Translator t = translators.get(snapshot.getMimeType());
            if (t != null) {
                return Collections.singleton(new JsEmbeddingProvider(snapshot.getMimeType(), t));
            }
            if (snapshot.getMimeType().equals(JsEmbeddingProvider.JS_MIMETYPE)) {
                return Collections.singleton(new JsEmbeddingProvider(snapshot.getMimeType(), translators.get(JsEmbeddingProvider.JSX_MIME_TYPE)));
            }
            return Collections.emptyList();
        }
    }
}

