/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class UnifyAccessType
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public UnifyAccessType(FileObject fileObject, ElementHandle<TypeElement> classHandle) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)UnifyAccessType.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    for (ExecutableElement methodElem : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                        VariableElement fieldElem;
                        if (!methodElem.getSimpleName().toString().startsWith("get") || (fieldElem = ModelUtils.getField(clazz, ModelUtils.getFieldNameFromAccessor(methodElem.getSimpleName().toString()))) == null) continue;
                        MethodTree methodTree = workingCopy.getTrees().getTree(methodElem);
                        VariableTree fieldTree = (VariableTree)workingCopy.getTrees().getTree(fieldElem);
                        ModifiersTree srcModifiersTree = UnifyAccessType.this.getSourceModifiers(fieldTree, methodTree);
                        LinkedList<AnnotationTree> remainingAnnotations = new LinkedList<AnnotationTree>();
                        LinkedList<? extends AnnotationTree> newTargetAnnots = new LinkedList<AnnotationTree>();
                        for (AnnotationTree annotationTree : srcModifiersTree.getAnnotations()) {
                            if (UnifyAccessType.this.isJPAAttrAnnotation((CompilationInfo)workingCopy, annotationTree)) {
                                newTargetAnnots.add(annotationTree);
                                continue;
                            }
                            remainingAnnotations.add(annotationTree);
                        }
                        if (newTargetAnnots.size() <= 0) continue;
                        TreeMaker make = workingCopy.getTreeMaker();
                        ModifiersTree modifiersTree = UnifyAccessType.this.getTargetModifiers(fieldTree, methodTree);
                        workingCopy.rewrite((Tree)srcModifiersTree, (Tree)make.Modifiers(srcModifiersTree, remainingAnnotations));
                        newTargetAnnots.addAll(modifiersTree.getAnnotations());
                        workingCopy.rewrite((Tree)modifiersTree, (Tree)make.Modifiers(modifiersTree, newTargetAnnots));
                    }
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    protected abstract ModifiersTree getSourceModifiers(VariableTree var1, MethodTree var2);

    protected abstract ModifiersTree getTargetModifiers(VariableTree var1, MethodTree var2);

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    private boolean isJPAAttrAnnotation(CompilationInfo cinfo, AnnotationTree ann) {
        TreePath path = cinfo.getTrees().getPath(cinfo.getCompilationUnit(), ann.getAnnotationType());
        Element elem = cinfo.getTrees().getElement(path);
        String annType = elem.toString();
        return JPAAnnotations.MEMBER_LEVEL.contains(annType);
    }

    public static class UnifyFieldAccess
    extends UnifyAccessType {
        public UnifyFieldAccess(FileObject fileObject, ElementHandle<TypeElement> classHandle) {
            super(fileObject, classHandle);
        }

        public String getText() {
            return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_UnifyFieldAccess");
        }

        @Override
        protected ModifiersTree getSourceModifiers(VariableTree fieldTree, MethodTree methodTree) {
            return methodTree.getModifiers();
        }

        @Override
        protected ModifiersTree getTargetModifiers(VariableTree fieldTree, MethodTree methodTree) {
            return fieldTree.getModifiers();
        }
    }

    public static class UnifyPropertyAccess
    extends UnifyAccessType {
        public UnifyPropertyAccess(FileObject fileObject, ElementHandle<TypeElement> classHandle) {
            super(fileObject, classHandle);
        }

        public String getText() {
            return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_UnifyPropertyAccess");
        }

        @Override
        protected ModifiersTree getSourceModifiers(VariableTree fieldTree, MethodTree methodTree) {
            return fieldTree.getModifiers();
        }

        @Override
        protected ModifiersTree getTargetModifiers(VariableTree fieldTree, MethodTree methodTree) {
            return methodTree.getModifiers();
        }
    }
}

