/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.debugger.ui.views.debugging.DebuggingViewComponent;
import org.netbeans.modules.debugger.ui.views.debugging.InfoPanel;
import org.netbeans.spi.debugger.ui.DebuggingView;

public class ThreadsListener
extends DebuggerManagerAdapter {
    private static ThreadsListener instance;
    private static PropertyChangeSupport pchs;
    private static final ThreadsPropertyChangeListener tpchl;
    final LinkedList<DebuggingView.DVThread> currentThreadsHistory = new LinkedList();
    final BreakpointHits hits = new BreakpointHits();
    private Map<DebuggingView.DVSupport, DebuggerListener> debuggerToListener = new WeakHashMap<DebuggingView.DVSupport, DebuggerListener>();
    private DebuggingView.DVSupport currentDebugger = null;
    private DebuggingViewComponent debuggingView;

    @Deprecated
    public ThreadsListener() {
        instance = this;
    }

    public static ThreadsListener getDefault() {
        return instance;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        pchs.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        pchs.removePropertyChangeListener(listener);
    }

    public void setDebuggingView(DebuggingView.DVSupport dvs, DebuggingViewComponent debuggingView) {
        this.debuggingView = debuggingView;
        InfoPanel infoPanel = debuggingView.getInfoPanel();
        infoPanel.setBreakpointHits(dvs, this.getHits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeDebugger(DebuggingView.DVSupport deb) {
        InfoPanel infoPanel;
        if (this.currentDebugger == deb) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener(tpchl);
        }
        if (deb != null) {
            deb.addPropertyChangeListener(tpchl);
            DebuggingView.DVThread currThread = deb.getCurrentThread();
            if (currThread != null) {
                LinkedList<DebuggingView.DVThread> linkedList = this.currentThreadsHistory;
                synchronized (linkedList) {
                    this.currentThreadsHistory.remove(currThread);
                    this.currentThreadsHistory.addFirst(currThread);
                }
            }
        }
        if (this.debuggingView == null) {
            this.currentDebugger = deb;
            return;
        }
        if (this.currentDebugger != null) {
            infoPanel = this.debuggingView.getInfoPanel();
            infoPanel.setShowDeadlock(false);
            infoPanel.setShowThreadLocks(null, null);
            infoPanel.setShowStepBrkp(null, null, null);
        }
        if (deb != null) {
            infoPanel = this.debuggingView.getInfoPanel();
            DebuggerListener listener = this.debuggerToListener.get(deb);
            if (listener != null) {
                if (deb.getDeadlocks() != null) {
                    infoPanel.setShowDeadlock(true);
                }
                infoPanel.setShowThreadLocks(listener.lockedThread, listener.lockerThreads);
                infoPanel.setShowStepBrkp(listener.debugger, listener.stepBrkpThread, listener.stepBrkpBreakpoint);
            }
            infoPanel.recomputeMenuItems(deb, this.getHits());
        } else {
            this.debuggingView = null;
        }
        this.currentDebugger = deb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DebuggingView.DVThread> getCurrentThreadsHistory() {
        LinkedList<DebuggingView.DVThread> linkedList = this.currentThreadsHistory;
        synchronized (linkedList) {
            ArrayList<DebuggingView.DVThread> result = new ArrayList<DebuggingView.DVThread>(this.currentThreadsHistory.size());
            for (DebuggingView.DVThread thread : this.currentThreadsHistory) {
                if (!thread.isSuspended()) continue;
                result.add(thread);
            }
            return result;
        }
    }

    public synchronized List<DebuggingView.DVThread> getThreads() {
        ArrayList<DebuggingView.DVThread> result = new ArrayList<DebuggingView.DVThread>();
        for (DebuggingView.DVSupport debugger : this.debuggerToListener.keySet()) {
            if (debugger == null || debugger.getState() == DebuggingView.DVSupport.STATE.DISCONNECTED) continue;
            result.addAll(debugger.getAllThreads());
        }
        return result;
    }

    private void addBreakpointHit(DebuggingView.DVThread thread) {
        if (thread != null && !this.hits.contains(thread)) {
            this.hits.add(thread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().addBreakpointHit(thread, this.hits.size());
            }
        }
    }

    private void removeBreakpointHit(DebuggingView.DVThread thread) {
        if (thread != null && this.hits.contains(thread)) {
            this.hits.remove(thread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().removeBreakpointHit(thread, this.hits.size());
            }
        }
    }

    public synchronized List<DebuggingView.DVThread> getHits() {
        ArrayList<DebuggingView.DVThread> result = new ArrayList<DebuggingView.DVThread>();
        for (DebuggingView.DVThread thread : this.hits.getStoppedThreads()) {
            result.add(thread);
        }
        return result;
    }

    public synchronized int getHitsCount() {
        return this.hits.size();
    }

    public synchronized boolean isBreakpointHit(DebuggingView.DVThread thread) {
        return this.hits.contains(thread);
    }

    public synchronized void goToHit() {
        this.hits.goToHit();
    }

    public DebuggingView.DVSupport getDVSupport() {
        return this.currentDebugger;
    }

    public String[] getProperties() {
        return new String[]{"debuggerEngines"};
    }

    public synchronized void engineAdded(DebuggerEngine engine) {
        DebuggingView.DVSupport deb = (DebuggingView.DVSupport)engine.lookupFirst(null, DebuggingView.DVSupport.class);
        if (deb != null) {
            DebuggerListener listener = new DebuggerListener(deb);
            this.debuggerToListener.put(deb, listener);
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    public synchronized void engineRemoved(DebuggerEngine engine) {
        DebuggingView.DVSupport deb = (DebuggingView.DVSupport)engine.lookupFirst(null, DebuggingView.DVSupport.class);
        if (deb != null) {
            DebuggerListener listener = this.debuggerToListener.remove(deb);
            if (listener != null) {
                listener.unregister();
            }
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    static {
        pchs = new PropertyChangeSupport(ThreadsListener.class);
        tpchl = new ThreadsPropertyChangeListener();
    }

    static class BreakpointHits {
        private Set<DebuggingView.DVThread> stoppedThreadsSet = new HashSet<DebuggingView.DVThread>();
        private LinkedList<DebuggingView.DVThread> stoppedThreads = new LinkedList();

        BreakpointHits() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void goToHit() {
            DebuggingView.DVThread thread;
            BreakpointHits breakpointHits = this;
            synchronized (breakpointHits) {
                thread = this.stoppedThreads.getLast();
            }
            thread.makeCurrent();
        }

        public synchronized boolean contains(DebuggingView.DVThread thread) {
            return this.stoppedThreadsSet.contains(thread);
        }

        public synchronized boolean add(DebuggingView.DVThread thread) {
            if (this.stoppedThreadsSet.add(thread)) {
                this.stoppedThreads.addFirst(thread);
                return true;
            }
            return false;
        }

        public synchronized boolean remove(DebuggingView.DVThread thread) {
            if (this.stoppedThreadsSet.remove(thread)) {
                this.stoppedThreads.remove(thread);
                return true;
            }
            return false;
        }

        public synchronized void clear() {
            this.stoppedThreadsSet.clear();
            this.stoppedThreads.clear();
        }

        public synchronized int size() {
            return this.stoppedThreads.size();
        }

        private synchronized Iterable<DebuggingView.DVThread> getStoppedThreads() {
            return new ArrayList<DebuggingView.DVThread>(this.stoppedThreads);
        }
    }

    private static class ThreadsPropertyChangeListener
    implements PropertyChangeListener {
        private ThreadsPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            pchs.firePropertyChange(evt);
        }
    }

    class DebuggerListener
    implements PropertyChangeListener {
        private DebuggingView.DVSupport debugger;
        Set<DebuggingView.DVThread> threads = new HashSet<DebuggingView.DVThread>();
        List<DebuggingView.DVThread> lockerThreads;
        DebuggingView.DVThread lockedThread;
        DebuggingView.DVThread stepBrkpThread;
        Breakpoint stepBrkpBreakpoint;

        DebuggerListener(DebuggingView.DVSupport debugger) {
            this.debugger = debugger;
            debugger.addPropertyChangeListener(this);
            List<DebuggingView.DVThread> allThreads = debugger.getAllThreads();
            for (DebuggingView.DVThread thread : allThreads) {
                this.threads.add(thread);
                thread.addPropertyChangeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object source = evt.getSource();
            if (source instanceof DebuggingView.DVSupport) {
                if ("threadStarted".equals(propName)) {
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getNewValue();
                    if (this.threads.add(dvThread)) {
                        dvThread.addPropertyChangeListener(this);
                    }
                } else if ("threadDied".equals(propName)) {
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getOldValue();
                    if (this.threads.remove(dvThread)) {
                        LinkedList<DebuggingView.DVThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                        synchronized (linkedList) {
                            ThreadsListener.this.currentThreadsHistory.remove(dvThread);
                        }
                        dvThread.removePropertyChangeListener(this);
                        ThreadsListener.this.removeBreakpointHit(dvThread);
                    }
                } else if ("currentThread".equals(propName)) {
                    DebuggingView.DVThread currentThread = this.debugger.getCurrentThread();
                    if (currentThread != null) {
                        ThreadsListener.this.removeBreakpointHit(currentThread);
                        LinkedList<DebuggingView.DVThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                        synchronized (linkedList) {
                            ThreadsListener.this.currentThreadsHistory.remove(currentThread);
                            ThreadsListener.this.currentThreadsHistory.addFirst(currentThread);
                        }
                    }
                } else if ("state".equals(propName) && this.debugger != null && this.debugger.getState() == DebuggingView.DVSupport.STATE.DISCONNECTED) {
                    this.unregister();
                } else if ("deadlock".equals(propName)) {
                    this.setShowDeadlock(true);
                }
            } else if (source instanceof DebuggingView.DVThread) {
                DebuggingView.DVThread thread = (DebuggingView.DVThread)source;
                if ("currentBreakpoint".equals(propName)) {
                    if (!this.isCurrent(thread)) {
                        if (this.isAtBreakpoint(thread)) {
                            ThreadsListener.this.addBreakpointHit(thread);
                        } else {
                            ThreadsListener.this.removeBreakpointHit(thread);
                        }
                    } else {
                        ThreadsListener.this.removeBreakpointHit(thread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("suspended".equals(propName)) {
                    if (!thread.isSuspended()) {
                        ThreadsListener.this.removeBreakpointHit(thread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("lockerThreads".equals(propName)) {
                    List<DebuggingView.DVThread> currLockerThreads = thread.getLockerThreads();
                    this.setShowThreadLocks(thread, currLockerThreads);
                } else if ("stepSuspendedByBreakpoint".equals(propName)) {
                    this.setShowStepBrkp(thread, (Breakpoint)evt.getNewValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void unregister() {
            if (this.debugger == null) {
                return;
            }
            for (DebuggingView.DVThread thread : this.threads) {
                thread.removePropertyChangeListener(this);
            }
            Object object = ThreadsListener.this.currentThreadsHistory;
            synchronized (object) {
                for (DebuggingView.DVThread thread : this.threads) {
                    ThreadsListener.this.currentThreadsHistory.remove(thread);
                }
            }
            object = ThreadsListener.this.hits;
            synchronized (object) {
                for (DebuggingView.DVThread thread : this.threads) {
                    ThreadsListener.this.removeBreakpointHit(thread);
                }
            }
            this.threads.clear();
            this.lockedThread = null;
            this.lockerThreads = null;
            this.stepBrkpThread = null;
            this.stepBrkpBreakpoint = null;
            this.debugger.removePropertyChangeListener(this);
            this.debugger.removePropertyChangeListener(this);
            this.debugger = null;
        }

        private boolean isCurrent(DebuggingView.DVThread thread) {
            return this.debugger.getCurrentThread() == thread;
        }

        private boolean isAtBreakpoint(DebuggingView.DVThread thread) {
            Breakpoint breakpoint = thread.getCurrentBreakpoint();
            return breakpoint != null;
        }

        private void setShowDeadlock(boolean detected) {
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowDeadlock(detected);
            }
        }

        private void setShowThreadLocks(DebuggingView.DVThread thread, List<DebuggingView.DVThread> currLockerThreads) {
            this.lockerThreads = currLockerThreads;
            this.lockedThread = thread;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowThreadLocks(thread, this.lockerThreads);
            }
        }

        private void setShowStepBrkp(DebuggingView.DVThread thread, Breakpoint breakpoint) {
            this.stepBrkpThread = thread;
            this.stepBrkpBreakpoint = breakpoint;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowStepBrkp(this.debugger, thread, breakpoint);
            }
        }
    }
}

