/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.GenerateJavadocFix;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavadocHint {
    public static final String SCOPE_KEY = "scope";
    public static final String SCOPE_DEFAULT = "protected";
    public static final String AVAILABILITY_KEY = "availability";

    public static List<ErrorDescription> createHint(HintContext ctx) {
        boolean isPubliclyA11e;
        Preferences pref = ctx.getPreferences();
        boolean createJavadocForNonPublic = pref.getBoolean("availabilitytrue", false);
        CompilationInfo javac = ctx.getInfo();
        Boolean publiclyAccessible = AccessibilityQuery.isPubliclyAccessible((FileObject)javac.getFileObject().getParent());
        boolean bl = isPubliclyA11e = publiclyAccessible == null ? true : publiclyAccessible;
        if (!isPubliclyA11e && !createJavadocForNonPublic) {
            return null;
        }
        if (javac.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        TreePath currentPath = ctx.getPath();
        Severity severity = ctx.getSeverity();
        Access access = Access.resolve(pref.get(SCOPE_KEY, SCOPE_DEFAULT));
        List<ErrorDescription> errors = Collections.emptyList();
        int caretLocation = ctx.isBulkMode() ? -1 : CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)ctx.getInfo().getFileObject());
        Tree node = currentPath.getLeaf();
        if (javac.getTreeUtilities().isSynthetic(currentPath) || !JavadocUtilities.isValid(javac, currentPath, severity, access, caretLocation)) {
            return errors;
        }
        Element elm = javac.getTrees().getElement(currentPath);
        if (elm == null) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, "Cannot resolve element for {0} in {1}", new Object[]{node, javac.getFileObject()});
            return errors;
        }
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (doc != null && JavadocUtilities.isGuarded(node, javac, doc)) {
            return errors;
        }
        DocCommentTree docCommentTree = ((DocTrees)javac.getTrees()).getDocCommentTree(currentPath);
        if (docCommentTree == null || docCommentTree.getFirstSentence().isEmpty() && docCommentTree.getBody().isEmpty() && docCommentTree.getBlockTags().isEmpty() && elm.getKind() != ElementKind.ENUM_CONSTANT && elm.getKind() != ElementKind.FIELD) {
            if (JavadocUtilities.hasErrors(node) || JavadocUtilities.hasInheritedDoc(javac, elm)) {
                return errors;
            }
            int[] positions = JavadocUtilities.createSignaturePositions(node, javac);
            if (positions == null) {
                return errors;
            }
            TreePathHandle handle = TreePathHandle.create((TreePath)currentPath, (CompilationInfo)javac);
            String description = elm.getKind() == ElementKind.CONSTRUCTOR ? elm.getEnclosingElement().getSimpleName().toString() : elm.getSimpleName().toString();
            errors = new ArrayList<ErrorDescription>();
            GenerateJavadocFix javadocFix = new GenerateJavadocFix(description, handle, ctx.getInfo().getSourceVersion());
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)ctx, (int)positions[0], (int)positions[1], (String)NbBundle.getMessage(Analyzer.class, (String)"MISSING_JAVADOC_DESC"), (Fix[])new Fix[]{javadocFix.toEditorFix()}));
        }
        return errors;
    }

    public static List<ErrorDescription> errorHint(HintContext ctx) {
        boolean isPubliclyA11e;
        Preferences pref = ctx.getPreferences();
        boolean correctJavadocForNonPublic = pref.getBoolean("availabilityfalse", false);
        CompilationInfo javac = ctx.getInfo();
        Boolean publiclyAccessible = AccessibilityQuery.isPubliclyAccessible((FileObject)javac.getFileObject().getParent());
        boolean bl = isPubliclyA11e = publiclyAccessible == null ? true : publiclyAccessible;
        if (!isPubliclyA11e && !correctJavadocForNonPublic) {
            return null;
        }
        if (javac.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        TreePath path = ctx.getPath();
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (doc != null && JavadocUtilities.isGuarded(path.getLeaf(), javac, doc)) {
            return null;
        }
        Access access = Access.resolve(pref.get(SCOPE_KEY, SCOPE_DEFAULT));
        Analyzer a = new Analyzer(javac, path, access, ctx);
        return a.analyze();
    }

    private static JComponent createCustomizer(final Preferences node, final boolean createJavadocKind) {
        JPanel outerPanel = new JPanel(new GridBagLayout());
        outerPanel.setOpaque(false);
        JPanel res = new JPanel(new GridBagLayout());
        res.setOpaque(false);
        res.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(JavadocHint.class, (String)"LBL_SCOPE")));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton rb = (JRadioButton)e.getSource();
                node.put(JavadocHint.SCOPE_KEY, rb.getText());
            }
        };
        ButtonGroup group = new ButtonGroup();
        int row = 0;
        JRadioButton radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHint.class, (String)"CTL_PUBLIC_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHint.class, (String)"HINT_PUBLIC_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHint.class, (String)"ACD_PUBLIC_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHint.class, (String)"ACN_PUBLIC_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        if (radio.isSelected()) {
            node.put(SCOPE_KEY, radio.getText());
        }
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHint.class, (String)"CTL_PROTECTED_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHint.class, (String)"HINT_PROTECTED_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHint.class, (String)"ACD_PROTECTED_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHint.class, (String)"ACN_PROTECTED_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        if (radio.isSelected()) {
            node.put(SCOPE_KEY, radio.getText());
        }
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHint.class, (String)"CTL_PACKAGE_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHint.class, (String)"HINT_PACKAGE_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHint.class, (String)"ACD_PACKAGE_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHint.class, (String)"ACN_PACKAGE_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        if (radio.isSelected()) {
            node.put(SCOPE_KEY, radio.getText());
        }
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHint.class, (String)"CTL_PRIVATE_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHint.class, (String)"HINT_PRIVATE_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHint.class, (String)"ACD_PRIVATE_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHint.class, (String)"ACN_PRIVATE_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        if (radio.isSelected()) {
            node.put(SCOPE_KEY, radio.getText());
        }
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        outerPanel.add((Component)res, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JCheckBox apiCheckbox = new JCheckBox();
        apiCheckbox.setText(NbBundle.getMessage(JavadocHint.class, (String)"CTL_APICHECKBOX"));
        apiCheckbox.setSelected(node.getBoolean(AVAILABILITY_KEY + createJavadocKind, false));
        apiCheckbox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHint.class, (String)"AN_APICHECKBOX"));
        apiCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHint.class, (String)"AD_APICHECKBOX"));
        apiCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                node.putBoolean(JavadocHint.AVAILABILITY_KEY + createJavadocKind, cb.isSelected());
            }
        });
        outerPanel.add((Component)apiCheckbox, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        node.putBoolean(AVAILABILITY_KEY + createJavadocKind, apiCheckbox.isSelected());
        return outerPanel;
    }

    public static final class CustomizerProviderImplError
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return JavadocHint.createCustomizer(prefs, false);
        }
    }

    public static final class CustomizerProviderImplCreate
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return JavadocHint.createCustomizer(prefs, true);
        }
    }
}

