/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.ui.action.command.Command;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class BrowserCommand
extends Command {
    private final String commandId;

    public BrowserCommand(ClientSideProject project, String commandId) {
        super(project);
        assert (commandId != null);
        this.commandId = commandId;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    boolean isActionEnabledInternal(Lookup context) {
        if (this.project.isJsLibrary()) {
            return false;
        }
        if (!this.project.isRunBrowser()) {
            return false;
        }
        if (this.isFileCommand() && this.isJsFileCommand(context)) {
            return false;
        }
        ActionProvider actionProvider = this.getBrowserActionProvider();
        if (actionProvider != null && BrowserCommand.isSupportedAction(this.getCommandId(), actionProvider)) {
            return actionProvider.isActionEnabled(this.getCommandId(), context);
        }
        return false;
    }

    @Override
    void invokeActionInternal(final Lookup context) {
        if (this.project.isJsLibrary()) {
            return;
        }
        if (!this.project.isRunBrowser()) {
            return;
        }
        if (this.isFileCommand() && this.isJsFileCommand(context)) {
            return;
        }
        this.project.logBrowserUsage();
        final ActionProvider actionProvider = this.getBrowserActionProvider();
        if (actionProvider != null) {
            assert (BrowserCommand.isSupportedAction(this.getCommandId(), actionProvider)) : this.getCommandId() + " :: " + actionProvider;
            if (actionProvider.isActionEnabled(this.commandId, context)) {
                BrowserCommand.runInEventThread(new Runnable(){

                    @Override
                    public void run() {
                        actionProvider.invokeAction(BrowserCommand.this.getCommandId(), context);
                    }
                });
            }
        }
    }

    public List<String> getSupportedActions() {
        ActionProvider actionProvider = this.getBrowserActionProvider();
        if (actionProvider == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(actionProvider.getSupportedActions());
    }

    @CheckForNull
    private ActionProvider getBrowserActionProvider() {
        ClientProjectEnhancedBrowserImplementation browserImplementation = this.project.getEnhancedBrowserImpl();
        if (browserImplementation != null) {
            return browserImplementation.getActionProvider();
        }
        return null;
    }

    private boolean isFileCommand() {
        switch (this.commandId) {
            case "run.single": 
            case "debug.single": {
                return true;
            }
        }
        return false;
    }

    private boolean isJsFileCommand(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        return fo != null && FileUtilities.isJavaScriptFile(fo);
    }
}

