/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.Dxf14Convertable;
import de.escape.quincunx.dxf.reader.Dxf14Converter;
import de.escape.quincunx.dxf.reader.DxfConvertable;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfInterface;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;

public class DxfEntity
implements DxfInterface,
DxfConvertable,
Dxf14Convertable {
    private String reference;
    private String ltype;
    private String layerName;
    private float height;
    private float extrusion;
    protected short color = (short)-1;
    private boolean tile;
    private Vector3D upward = new Vector3D(0.0f, 0.0f, 1.0f);
    private float ltScale = 1.0f;
    private boolean invisible = false;
    private boolean upwardIsZ;
    private boolean hasExpliciteZ;
    private DxfLAYER layer;

    protected void setCoord(Point3D pt, int dir, float val) {
        switch (dir) {
            case 1: {
                pt.x = val;
                break;
            }
            case 2: {
                pt.y = val;
                break;
            }
            case 3: {
                this.hasExpliciteZ = true;
                pt.z = val;
                break;
            }
        }
    }

    protected void setCoord(Vector3D v, int dir, float val) {
        switch (dir) {
            case 1: {
                v.x = val;
                break;
            }
            case 2: {
                v.y = val;
                break;
            }
            case 3: {
                v.z = val;
                break;
            }
        }
    }

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 38: {
                this.hasExpliciteZ = true;
                this.height = fval;
                return true;
            }
            case 39: {
                this.extrusion = fval;
                return true;
            }
            case 48: {
                this.ltScale = fval;
                return true;
            }
            case 210: 
            case 220: 
            case 230: {
                this.setCoord(this.upward, (grpNr - 200) / 10, fval);
                return true;
            }
        }
        return false;
    }

    public boolean setGroup(short grpNr, short color) {
        if (grpNr == 62) {
            this.color = color;
            return true;
        }
        return false;
    }

    public boolean setGroup(short grpNr, int ival) {
        if (grpNr == 67) {
            this.tile = ival != 0;
            return true;
        }
        return false;
    }

    public boolean setGroup(short grpNr, String str) {
        switch (grpNr) {
            case 5: {
                this.reference = str;
                return true;
            }
            case 6: {
                this.ltype = str;
                return true;
            }
            case 8: {
                this.layerName = str;
                return true;
            }
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean finishRead(DxfFile file) {
        float len = this.upward.length();
        if (len != 1.0f) {
            if (len != 0.0f) {
                this.upward.scale(1.0f / len);
            } else {
                return false;
            }
        }
        boolean bl = this.upwardIsZ = this.upward.x == 0.0f && this.upward.y == 0.0f && this.upward.z > 0.0f;
        if (this.layerName == null) {
            this.layerName = "0";
        }
        this.layer = file.getLayer(this.layerName, true);
        return true;
    }

    boolean isTerm() {
        return false;
    }

    boolean isENDSEC() {
        return false;
    }

    boolean isBlockNamed(String name) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final Matrix4D calcArbitMat() {
        if (this.upwardIsZ && this.height == 0.0f) {
            return null;
        }
        v0 = this.upward.x < 0.0f ? -this.upward.x : this.upward.x;
        if (!(v0 < 0.015625f)) ** GOTO lbl-1000
        v1 = this.upward.y < 0.0f ? -this.upward.y : this.upward.y;
        if (v1 < 0.015625f) {
            row1 = new Vector3D(this.upward.z, 0.0f, -this.upward.x);
        } else lbl-1000:
        // 2 sources

        {
            row1 = new Vector3D(-this.upward.y, this.upward.x, 0.0f);
        }
        len = row1.length();
        row1.scale(1.0f / len);
        row2 = this.upward.cross(row1);
        aaa = new Matrix4D(row1.x, row2.x, this.upward.x, this.height * this.upward.x, row1.y, row2.y, this.upward.y, this.height * this.upward.y, row1.z, row2.z, this.upward.z, this.height * this.upward.z, 0.0f, 0.0f, 0.0f, 1.0f);
        return aaa;
    }

    public final String getReference() {
        return this.reference;
    }

    public final String getLayerName() {
        return this.layerName;
    }

    public final DxfLAYER getLayer() {
        return this.layer;
    }

    public final String getLtypeName() {
        return this.ltype == null ? "BYLAYER" : this.ltype;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getExtrusion() {
        return this.extrusion;
    }

    public short getColor() {
        return this.color;
    }

    public final float getLtScale() {
        return this.ltScale;
    }

    public final boolean isInvisible() {
        return this.invisible;
    }

    public boolean getTile() {
        return this.tile;
    }

    public final Vector3D getUpwardVector() {
        return this.upward;
    }

    public final boolean upwardIsZ() {
        return this.upwardIsZ;
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
    }

    public void convert(Dxf14Converter converter, DxfFile dxf, Object collector) {
        this.convert((DxfConverter)converter, dxf, collector);
    }

    public DxfEntityCollector getEntityCollector() {
        return null;
    }

    void setExternalZ(float z) {
        if (!this.hasExpliciteZ) {
            this.height = z;
        }
    }
}

