/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.saxtree;

import java.util.List;
import nu.validator.saxtree.NodeType;
import nu.validator.saxtree.ParentNode;
import nu.validator.saxtree.PrefixMapping;
import nu.validator.saxtree.TreeParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class Element
extends ParentNode {
    private final String uri;
    private final String localName;
    private final String qName;
    private final Attributes attributes;
    private final List<PrefixMapping> prefixMappings;

    public Element(Locator locator, String uri, String localName, String qName, Attributes atts, boolean retainAttributes, List<PrefixMapping> prefixMappings) {
        super(locator);
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.attributes = retainAttributes ? atts : new AttributesImpl(atts);
        this.prefixMappings = prefixMappings;
    }

    @Override
    void visit(TreeParser treeParser) throws SAXException {
        if (this.prefixMappings != null) {
            for (PrefixMapping mapping : this.prefixMappings) {
                treeParser.startPrefixMapping(mapping.getPrefix(), mapping.getUri(), this);
            }
        }
        treeParser.startElement(this.uri, this.localName, this.qName, this.attributes, this);
    }

    @Override
    void revisit(TreeParser treeParser) throws SAXException {
        treeParser.endElement(this.uri, this.localName, this.qName, this.endLocator);
        if (this.prefixMappings != null) {
            for (PrefixMapping mapping : this.prefixMappings) {
                treeParser.endPrefixMapping(mapping.getPrefix(), this.endLocator);
            }
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public List<PrefixMapping> getPrefixMappings() {
        return this.prefixMappings;
    }

    @Override
    public String getQName() {
        return this.qName;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ELEMENT;
    }
}

