<TeXmacs|2.1.1>

<style|<tuple|tmdoc|maxima|english|old-spacing|old-dots|old-lengths>>

<\body>
  <\tmdoc-title>
    Example <name|Gnuplot> session
  </tmdoc-title>

  Select <menu|Insert|Session|Gnuplot> in order to start a <name|Gnuplot>
  session. After pressing <key|return> in a line, your input will be sent to
  <name|Gnuplot>. If you need to enter more than one command then you may
  separate them by <verbatim|~> or a newline, which you insert using
  <key|S-return>. Alternatively you may select <menu|Focus|Input
  options|Multiline input> to reverse the behaviour of the keys. Each input
  must be a complete script ending with a plotting command, i.e. the result
  must always be an image to embed into <TeXmacs>.

  <name|Gnuplot> supports many features which allow the creation of high
  quality graphs. Here are some examples:

  <\session|gnuplot|default>
    <\output>
      This is a TeXmacs interface for GNUplot.
    </output>

    <\unfolded-io>
      gnuplot]\ 
    <|unfolded-io>
      plot [-10:10][-10:10] x+sin(x)
    <|unfolded-io>
      <image|<tuple|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|svg>|0.8par|||>
    </unfolded-io>

    <\unfolded-io>
      gnuplot]\ 
    <|unfolded-io>
      set noclip

      set yrange[-30:10]

      plot x*(abs((x-4)/(x+4)))**(1./2.)
    <|unfolded-io>
      <image|<tuple|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|svg>|0.8par|||>
    </unfolded-io>

    <\unfolded-io>
      gnuplot]\ 
    <|unfolded-io>
      set key bmargin left horizontal Right noreverse enhanced autotitle box
      lt black linewidth 1.000 dashtype solid

      set style increment default

      set samples 800, 800

      set title "Simple Plots"\ 

      set title \ font ",20" norotate

      set xrange [ * : * ] noreverse writeback

      set x2range [ * : * ] noreverse writeback

      set yrange [ * : * ] noreverse writeback

      set y2range [ * : * ] noreverse writeback

      set zrange [ * : * ] noreverse writeback

      set cbrange [ * : * ] noreverse writeback

      set rrange [ * : * ] noreverse writeback

      plot [-30:20] sin(x*20)*atan(x)
    <|unfolded-io>
      <image|<tuple|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|svg>|0.8par|||>
    </unfolded-io>

    <\input>
      gnuplot]\ 
    <|input>
      \;
    </input>
  </session>

  <tmdoc-copyright|2003\U2020|Chu-Ching Huang|Miguel de Benito Delgado|Darcy
  Shen>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<initial|<\collection>
</collection>>