# MenuLibre
**MenuLibre** is an advanced FreeDesktop.org compliant menu editor.

![MenuLibre window](https://github.com/bluesabre/menulibre/blob/wiki-assets/readme/menulibre-github.png)

All fields specified in the FreeDesktop.org [Desktop Entry](https://specifications.freedesktop.org/desktop-entry-spec/latest/) and [Menu](https://specifications.freedesktop.org/menu-spec/latest/) 
specifications are available to quickly update.
Additionally, MenuLibre provides an editor for the launcher actions 
used by applications such as Unity and Plank.

## Features
 - A beautiful interface powered by the latest version of GTK+
 - Create new launchers, or modify existing ones with complete control over common settings and access to advanced settings
 - Add, remove, and adjust desktop actions: powerful shortcuts available used by Unity, Xfce, and Pantheon
 - Easily rearrange menu items to suit your needs

### Build Requirements
 - gir1.2-gtk-3.0
 - intltool
 - libgnome-menu-3-dev
 - python-gi-dev
 - python3
 - [python3-distutils-extra](https://launchpad.net/python-distutils-extra)
 - python3-psutil

### Runtime Requirements
 - gir1.2-gdkpixbuf-2.0 
 - gir1.2-glib-2.0
 - gir1.2-gmenu-3.0 
 - gir1.2-gtk-3.0 
 - gir1.2-gtksource-3.0
 - gnome-menus 
 - python3 
 - python3-gi
 - python3-psutil 
 - xdg-utils 

## Installation

 1. Install the above build requirements
 2. Run the installer: \
    sudo python3 setup.py install

## Links
 - [Homepage](https://bluesabre.org/menulibre/)
 - [Releases](https://github.com/bluesabre/menulibre/releases)
 - [Bug Reports](https://github.com/bluesabre/menulibre/issues)
 - [Translations](https://www.transifex.com/bluesabreorg/menulibre)
 - [Wiki](https://github.com/bluesabre/menulibre/wiki)
