/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.core.NestedExceptionUtils;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5439915454935047936L;
    private Throwable cause;

    public NestedRuntimeException(String msg) {
        super(msg);
    }

    public NestedRuntimeException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        return NestedExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            ps.print("Caused by: ");
            this.getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            pw.print("Caused by: ");
            this.getCause().printStackTrace(pw);
        }
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause instanceof NestedRuntimeException) {
            Throwable rootCause = ((NestedRuntimeException)cause).getRootCause();
            return rootCause != null ? rootCause : cause;
        }
        return cause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)cause).contains(exType);
        }
        return cause != null && exType.isInstance(cause);
    }
}

