/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context;

import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolderStrategy;
import org.springframework.security.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class ThreadLocalSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static ThreadLocal contextHolder = new ThreadLocal();

    public void clearContext() {
        contextHolder.set(null);
    }

    public SecurityContext getContext() {
        if (contextHolder.get() == null) {
            contextHolder.set(new SecurityContextImpl());
        }
        return (SecurityContext)contextHolder.get();
    }

    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        contextHolder.set(context);
    }
}

