/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnValueCount;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ValueTableCellRenderer
extends DefaultTableCellRenderer {
    DecimalFormat aldf;
    public Format fakeFormatter = new Format(){

        @Override
        public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition pos) {
            if (value instanceof Number) {
                return toAppendTo.append(ValueTableCellRenderer.this.aldf.format(value));
            }
            return toAppendTo.append(value.toString());
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("This formatter cannot parse");
        }
    };

    public ValueTableCellRenderer() {
        this.aldf = new DecimalFormat("#,##0.0");
        this.aldf.setMaximumFractionDigits(1);
        this.aldf.setMinimumFractionDigits(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formattedValue;
        if (value == null) {
            formattedValue = "";
        } else if (value instanceof Number) {
            formattedValue = this.aldf.format(value);
        } else if (value instanceof List) {
            if (((List)value).size() > 0) {
                ColumnValueCount valueCount = (ColumnValueCount)((Object)((List)value).get(0));
                formattedValue = String.valueOf(valueCount.getValue());
                if (valueCount.isOtherValues()) {
                    formattedValue = "<html><i>" + formattedValue + "</i></html>";
                }
            } else {
                formattedValue = "";
            }
            StringBuffer toolTip = new StringBuffer();
            toolTip.append("<html><table>");
            for (ColumnValueCount v : (List)value) {
                toolTip.append("<tr>");
                toolTip.append("<td align=\"left\">");
                if (v.getValue() == null) {
                    toolTip.append("null");
                } else if (v.isOtherValues()) {
                    toolTip.append("<i>" + v.getValue().toString() + "</i>");
                } else {
                    toolTip.append(v.getValue().toString());
                }
                toolTip.append("</td>");
                toolTip.append("<td>&nbsp;&nbsp;&nbsp;</td>");
                toolTip.append("<td align=\"right\"><b>[");
                toolTip.append(v.getCount());
                toolTip.append("]</td>");
                toolTip.append("</tr>");
            }
            toolTip.append("</table></html>");
            this.setToolTipText(toolTip.toString());
        } else {
            formattedValue = value == "Other Values" ? "<html><i>" + value.toString() + "</i></html>" : value.toString();
        }
        return super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
    }

    public Format getFormat() {
        return this.fakeFormatter;
    }
}

