/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public final class PatternMatchExpression
extends Expression {
    private final Operand selectOp;
    private final Operand patternOp;

    public PatternMatchExpression(Expression select, Pattern pattern) {
        this.selectOp = new Operand(this, select, new OperandRole(0, OperandUsage.NAVIGATION, SequenceType.ANY_SEQUENCE));
        this.patternOp = new Operand(this, pattern, OperandRole.INSPECT);
    }

    public Expression getSelectExpression() {
        return this.selectOp.getChildExpression();
    }

    public Pattern getPattern() {
        return (Pattern)this.patternOp.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp, this.patternOp);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        Item it;
        Pattern pattern = this.getPattern();
        SequenceIterator iter = this.getSelectExpression().iterate(c);
        while ((it = iter.next()) != null) {
            if (pattern.matches(it, c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        PatternMatchExpression exp = new PatternMatchExpression(this.selectOp.getChildExpression(), (Pattern)this.patternOp.getChildExpression());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PatternMatchExpression && ((PatternMatchExpression)other).getSelectExpression().equals(this.getSelectExpression()) && ((PatternMatchExpression)other).getPattern().equals(this.getSelectExpression());
    }

    @Override
    protected int computeHashCode() {
        return this.getSelectExpression().computeHashCode() << 5 ^ this.getPattern().computeHashCode();
    }

    @Override
    public String getExpressionName() {
        return "match";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("patMatch", this);
        this.getSelectExpression().export(destination);
        this.getPattern().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return "patMatch(" + this.getSelectExpression().toString() + "," + this.getPattern().toString() + ")";
    }

    @Override
    public String toShortString() {
        return "patMatch(" + this.getSelectExpression().toShortString() + "," + this.getPattern().toShortString() + ")";
    }
}

