/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json;

import com.google.inject.Inject;
import inet.ipaddr.IPAddressString;
import java.util.Collection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.json.ConfigurationService;
import org.apache.guacamole.net.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidationService {
    private static final Logger logger = LoggerFactory.getLogger(RequestValidationService.class);
    private ConfigurationService confService;

    @Inject
    public RequestValidationService(ConfigurationService confService) {
        this.confService = confService;
    }

    public boolean isAuthenticationAllowed(Credentials credentials) {
        Collection<String> trustedNetworks;
        try {
            trustedNetworks = this.confService.getTrustedNetworks();
        }
        catch (GuacamoleException e) {
            logger.warn("Authentication request from \"{}\" is DENIED due to parse error: {}", (Object)credentials.getRemoteAddress(), (Object)e.getMessage());
            logger.debug("Error parsing authentication request restrictions from guacamole.properties.", (Throwable)e);
            return false;
        }
        if (trustedNetworks.isEmpty()) {
            logger.debug("Authentication request from \"{}\" is ALLOWED (no restrictions).", (Object)credentials.getRemoteAddress());
            return true;
        }
        for (String network : trustedNetworks) {
            if (!new IPAddressString(network).contains(new IPAddressString(credentials.getRemoteAddress()))) continue;
            logger.debug("Authentication request from \"{}\" is ALLOWED (matched subnet).", (Object)credentials.getRemoteAddress());
            return true;
        }
        logger.debug("Authentication request from \"{}\" is DENIED (did not match subnet).", (Object)credentials.getRemoteAddress());
        return false;
    }
}

