/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBUtility;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CBLocalization {
    private static final Logger log = Logger.getLogger(CBLocalization.class.getName());
    Locale locale = null;
    MessageFormat messageFormatter = null;
    Hashtable translations = null;
    private boolean errorGiven = false;
    private boolean english = true;

    public CBLocalization(Locale locale, String path) {
        this.locale = locale;
        this.translations = new Hashtable(500);
        this.loadLanguageFile(path, locale);
        if (!locale.getLanguage().equals("en")) {
            this.english = false;
        }
        this.messageFormatter = new MessageFormat("");
        this.messageFormatter.setLocale(locale);
    }

    public String get(String key) {
        if (key == null) {
            return "null key";
        }
        if (this.translations == null || this.translations.size() == 0) {
            if (!this.errorGiven) {
                if (!this.english) {
                    log.warning("Unable to translate (" + key + ") - can't find language file.");
                }
                this.errorGiven = true;
            }
            return key;
        }
        try {
            String val = (String)this.translations.get(key);
            if (val == null) {
                if (!this.english) {
                    log.warning("Can't find translation for '" + key + "' - returning '" + key + "' unchanged.");
                }
                return key;
            }
            return val;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String get(String key, ArrayList args) {
        return this.get(key, args.toArray());
    }

    public String get(String key, Object[] args) {
        if (key == null) {
            return "null key";
        }
        String val = key;
        if (this.translations == null || this.translations.size() == 0) {
            if (!this.errorGiven) {
                if (!this.english) {
                    log.warning("Unable to translate (" + key + ") - can't find language file.");
                }
                this.errorGiven = true;
            }
        } else {
            try {
                val = (String)this.translations.get(key);
                if (val == null) {
                    if (!this.english) {
                        log.warning("Can't find translation for (" + key + ") - returning unchanged.");
                    }
                    val = key;
                }
            }
            catch (MissingResourceException e) {
                val = key;
            }
        }
        return MessageFormat.format(val, args);
    }

    private void loadLanguageFile(String path, Locale locale) {
        Vector names = CBLocalization.getLanguageFileNames(path, locale);
        if (names == null) {
            log.warning("Names are null");
            return;
        }
        for (int i = names.size() - 1; i >= 0; --i) {
            if (!this.loadData(new File(names.get(i).toString()))) continue;
            return;
        }
        log.warning("Unable to load language file '" + path + "'");
    }

    private static Vector getLanguageFileNames(String path, Locale locale) {
        if (locale == null) {
            log.warning("Locale is null");
            return null;
        }
        Vector<String> result = new Vector<String>(8);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        StringBuffer temp = new StringBuffer(path);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        temp.append(language);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        return result;
    }

    private boolean loadData(File file) {
        try {
            if (file == null || !file.exists()) {
                return false;
            }
            log.info("Reading data from " + file.getAbsolutePath());
            byte[] data = CBUtility.readStream(new FileInputStream(file));
            StringBuffer buffy = new StringBuffer(CBUtility.readI18NByteArray(data));
            buffy.insert(buffy.length(), '\n');
            return this.parseData(buffy.toString());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to read data from file '" + file.getAbsolutePath(), e);
            return false;
        }
    }

    protected boolean parseData(String text) {
        boolean success;
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            String line = text.substring(start, end);
            if ((line = line.trim()).startsWith("=")) {
                log.warning("Invalid entry in language file: '" + line + "'");
            } else if (line.length() != 0 && line.charAt(0) != '#') {
                try {
                    int equalPos = 0;
                    while (line.charAt((equalPos = line.indexOf(61, equalPos + 1)) - 1) == '\\') {
                    }
                    String key = this.unescape(line.substring(0, equalPos)).trim();
                    String trans = line.substring(equalPos + 1).trim();
                    this.translations.put(key, trans);
                }
                catch (Exception e) {
                    log.warning("Exception parsing data line '" + line + "' -> " + e);
                }
            }
            start = end + 1;
        }
        boolean bl = success = this.translations.size() > 0;
        if (!success) {
            log.warning("ParseData unsuccessfull - no new data found");
        }
        return success;
    }

    private String unescape(String escapeMe) {
        int pos = 0;
        while ((pos = escapeMe.indexOf(92, pos)) >= 0) {
            escapeMe = escapeMe.substring(0, pos) + escapeMe.substring(pos + 1);
        }
        return escapeMe;
    }

    public Enumeration keys() {
        return this.translations.keys();
    }

    public Enumeration getKeys() {
        return this.translations.keys();
    }

    public Object get(Object key) {
        return this.translations.get(key);
    }

    public Object getObject(Object key) {
        return this.translations.get(key);
    }

    public String getString(String key) {
        if (key == null) {
            return "";
        }
        Object o = this.translations.get(key);
        if (o == null) {
            return "";
        }
        return o instanceof String ? (String)o : o.toString();
    }

    public static Locale createLocale(String language) {
        if (language == null) {
            return Locale.getDefault();
        }
        String[] langs = Locale.getISOLanguages();
        for (int i = 0; i < langs.length; ++i) {
            if (!language.equalsIgnoreCase(langs[i])) continue;
            return new Locale(langs[i]);
        }
        return Locale.getDefault();
    }
}

