/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sequence;

import org.hibernate.MappingException;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.sequence.NextvalSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;

public final class OracleSequenceSupport
extends NextvalSequenceSupport {
    @Deprecated(forRemoval=true)
    public static final SequenceSupport INSTANCE = new OracleSequenceSupport(true, false);
    private final boolean requiresFromDual;
    private final boolean supportsIfExists;

    public static SequenceSupport getInstance(Dialect dialect) {
        return new OracleSequenceSupport(dialect.getVersion());
    }

    public OracleSequenceSupport(DatabaseVersion version) {
        this(version.isBefore(23), version.isSameOrAfter(23));
    }

    OracleSequenceSupport(boolean requiresFromDual, boolean supportsIfExists) {
        this.requiresFromDual = requiresFromDual;
        this.supportsIfExists = supportsIfExists;
    }

    @Override
    public String getFromDual() {
        return this.requiresFromDual ? " from dual" : "";
    }

    @Override
    public boolean sometimesNeedsStartingValue() {
        return true;
    }

    @Override
    public String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + (this.supportsIfExists ? "if exists " : "") + sequenceName;
    }
}

