/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.model;

import java.util.ArrayList;

public final class StateModel {
    private final ArrayList<Listener> listeners = new ArrayList();
    private int state;
    private int maxStates;

    public StateModel() {
        this(2);
    }

    public StateModel(int n) {
        assert (n > 0);
        this.maxStates = n;
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanged() {
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] listenerArray2 = this.listeners.toArray(new Listener[this.listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Listener listener : listenerArray2) {
                listener.stateChanged();
            }
            return;
        }
    }

    public boolean getBooleanState() {
        return this.state > 0;
    }

    public void setBooleanState(boolean bl) {
        this.setState(bl ? 1 : 0);
    }

    public void toggleBooleanState() {
        this.setState(this.state > 0 ? 0 : 1);
    }

    public int getState() {
        return this.state;
    }

    public void decrease() {
        if (--this.state < 0) {
            this.state = this.maxStates - 1;
        }
        this.fireChanged();
    }

    public void increase() {
        if (++this.state >= this.maxStates) {
            this.state = 0;
        }
        this.fireChanged();
    }

    public void setState(int n) {
        this.state = n;
        this.fireChanged();
    }

    public int getMaxStates() {
        return this.maxStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public static interface Listener {
        public void stateChanged();
    }
}

