/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ObjectStreamException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class Nil
extends Symbol {
    public static final Symbol NIL = new Nil(Lisp.PACKAGE_CL);

    public Nil(Package pkg) {
        super("NIL", pkg);
        pkg.addSymbol(this);
        this.initializeConstant(this);
    }

    @Override
    public Object javaInstance() {
        return null;
    }

    public Object javaInstance(Class c) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        return this.javaInstance();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.NULL;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.NULL;
    }

    @Override
    public LispObject getDescription() {
        return new SimpleString("The symbol NIL");
    }

    @Override
    public boolean getBooleanValue() {
        return false;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.NULL) {
            return T;
        }
        if (typeSpecifier == Symbol.LIST) {
            return T;
        }
        if (typeSpecifier == Symbol.SEQUENCE) {
            return T;
        }
        if (typeSpecifier == Symbol.SYMBOL) {
            return T;
        }
        if (typeSpecifier == Symbol.BOOLEAN) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.NULL) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.LIST) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.SEQUENCE) {
            return T;
        }
        if (typeSpecifier == BuiltInClass.SYMBOL) {
            return T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public boolean constantp() {
        return true;
    }

    @Override
    public final LispObject getSymbolValue() {
        return this;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public LispObject NTH(int index) {
        if (index < 0) {
            Lisp.error(new TypeError(String.valueOf(index) + " is not of type UNSIGNED-BYTE."));
        }
        return NIL;
    }

    @Override
    public LispObject elt(int index) {
        return Lisp.error(new TypeError("ELT: invalid index " + index + " for " + String.valueOf(this) + "."));
    }

    @Override
    public LispObject reverse() {
        return this;
    }

    @Override
    public LispObject nreverse() {
        return this;
    }

    @Override
    public LispObject[] copyToArray() {
        return new LispObject[0];
    }

    @Override
    public LispObject NOT() {
        return T;
    }

    @Override
    public final LispObject getSymbolFunction() {
        return null;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return NIL;
    }
}

