/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;

public abstract class FreeColGameObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColGameObject.class.getName());
    private static final int FREECOL_GAME_OBJECT_CLASS_INDEX = 50;
    private Game game;
    private boolean disposed = false;
    protected boolean initialized;

    protected FreeColGameObject() {
        this.game = (Game)this;
        this.disposed = false;
        this.initialized = false;
    }

    public FreeColGameObject(Game game) {
        this.game = game;
        this.internId(this.getXMLTagName() + ":" + game.getNextId());
        this.disposed = false;
        this.initialized = this.getId() != null;
    }

    public FreeColGameObject(Game game, String id) {
        this.game = game;
        this.internId(id);
        this.initialized = false;
        this.disposed = false;
    }

    public final void internId(String newId) {
        if (this.game != null && newId != null && this.isInternable()) {
            String oldId = this.getId();
            if (newId.equals(oldId)) {
                this.game.setFreeColGameObject(newId, this);
            } else {
                if (oldId != null) {
                    this.game.removeFreeColGameObject(oldId, "override");
                }
                this.setId(newId);
                this.game.addFreeColGameObject(newId, this);
            }
        } else {
            this.setId(newId);
        }
    }

    public void intern() {
        this.internId(this.getId());
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        LogBuilder lb = new LogBuilder(64);
        lb.add("Destroying:");
        for (FreeColGameObject fcgo : CollectionUtils.toList(this.getDisposables())) {
            lb.add(" ", fcgo.getId());
            fcgo.disposeResources();
        }
        lb.log(logger, Level.INFO);
    }

    public final void fundamentalDispose() {
        this.getGame().removeFreeColGameObject(this.getId(), "dispose");
        this.disposed = true;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Player owner;
        FreeColGameObject fcgo = this.copyInCast(other, FreeColGameObject.class);
        if (fcgo == null) {
            return false;
        }
        Player player = owner = this instanceof Ownable ? ((Ownable)((Object)this)).getOwner() : null;
        if (!super.copyIn(fcgo)) {
            return false;
        }
        Game game = this.getGame();
        this.game = game.updateRef(fcgo.getGame());
        this.disposed = fcgo.isDisposed();
        this.initialized = fcgo.isInitialized();
        if (owner != null) {
            game.checkOwners((Ownable)((Object)this), owner);
        }
        return true;
    }

    public boolean isInternable() {
        return true;
    }

    public Stream<FreeColGameObject> getDisposables() {
        return Stream.of(this);
    }

    public void disposeResources() {
        this.fundamentalDispose();
    }

    public FreeColGameObject getLinkTarget(Player player) {
        return null;
    }

    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        return Constants.IntegrityType.INTEGRITY_GOOD;
    }

    @Override
    public Specification getSpecification() {
        return this.game == null ? null : this.game.getSpecification();
    }

    @Override
    public void setSpecification(Specification specification) {
        throw new RuntimeException("Can not set specification for: " + this);
    }

    @Override
    public final Game getGame() {
        return this.game;
    }

    @Override
    public final void setGame(Game game) {
        if (game == null) {
            throw new RuntimeException("Null game: " + this);
        }
        this.game = game;
    }

    @Override
    public int getClassIndex() {
        return 50;
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        if (xr.shouldIntern()) {
            this.internId(this.getId());
        }
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        this.initialized = true;
        super.readFromXML(xr);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FreeColGameObject) {
            FreeColGameObject other = (FreeColGameObject)o;
            return this.getGame() == other.getGame() && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Utils.hashCode(this.game);
    }
}

