/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.api.Access;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.ThreadedRunnable;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class RubyRunnable
implements ThreadedRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(RubyRunnable.class);
    private final Ruby runtime;
    private final RubyProc proc;
    private final IRubyObject[] arguments;
    private final int callInfo;
    private final RubyThread rubyThread;
    private volatile ThreadContext creatorContext;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, ThreadContext creatorContext, IRubyObject[] args2, Block currentBlock, int callInfo) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.arguments = args2;
        this.callInfo = callInfo;
        this.creatorContext = creatorContext;
    }

    @Deprecated
    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    @Override
    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldContextClassLoader;
        ThreadContext context;
        block25: {
            this.javaThread = Thread.currentThread();
            context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
            context.callInfo = this.callInfo;
            if (this.creatorContext != null && this.creatorContext.getFiber() != null) {
                context.getFiber().inheritFiberStorage(this.creatorContext);
            }
            this.creatorContext = null;
            oldContextClassLoader = null;
            try {
                oldContextClassLoader = this.javaThread.getContextClassLoader();
                this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (warnedAboutTC || !Access.instanceConfig(context).isVerbose()) break block25;
                warnedAboutTC = true;
                LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
            }
        }
        this.rubyThread.beforeStart();
        try {
            Block threadBlock = this.proc.getBlock();
            RubyModule frameClass = threadBlock.getFrame().getKlazz();
            String file2 = threadBlock.getBinding().getFile();
            int line = threadBlock.getBinding().getLine();
            try {
                IRRuntimeHelpers.callTrace(context, frameClass, RubyEvent.THREAD_BEGIN, null, file2, line);
                IRubyObject result2 = this.proc.call(context, this.arguments);
                IRRuntimeHelpers.callTrace(context, frameClass, RubyEvent.THREAD_END, null, file2, line);
                this.rubyThread.cleanTerminate(result2);
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            catch (IRBreakJump irbj) {
                this.rubyThread.exceptionRaised(Helpers.newLocalJumpErrorForBreak(this.runtime, irbj.breakValue));
            }
            catch (Throwable t) {
                this.rubyThread.exceptionRaised(t);
            }
            finally {
                block27: {
                    this.rubyThread.dispose();
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (warnedAboutTC || !Access.instanceConfig(context).isVerbose()) break block27;
                        warnedAboutTC = true;
                        LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                    }
                }
                if (Access.instanceConfig(context).isProfilingEntireRun()) {
                    this.runtime.printProfileData(context.getProfileCollection());
                }
            }
        }
        catch (ThreadKill threadKill) {
            // empty catch block
        }
    }
}

