/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.MessageBatch;

@MBean(description="Maintains averages of up and down threads")
public class THREAD_COUNT
extends Protocol {
    @Property(description="Enables the average for up threads")
    protected boolean up_threads = true;
    @Property(description="Enables the average for down threads")
    protected boolean down_threads = true;
    @ManagedAttribute(description="Average of up threads")
    protected final AverageMinMax avg_up = new AverageMinMax();
    @ManagedAttribute(description="Average of down threads")
    protected final AverageMinMax avg_down = new AverageMinMax();
    protected final AtomicInteger up_count = new AtomicInteger();
    protected final AtomicInteger down_count = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        if (!this.down_threads) {
            return this.down_prot.down(msg);
        }
        try {
            int cnt = this.down_count.incrementAndGet();
            Object object = this.avg_down;
            synchronized (object) {
                this.avg_down.add(cnt);
            }
            object = this.down_prot.down(msg);
            return object;
        }
        finally {
            this.down_count.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!this.up_threads) {
            return this.up_prot.up(msg);
        }
        try {
            int cnt = this.up_count.incrementAndGet();
            Object object = this.avg_up;
            synchronized (object) {
                this.avg_up.add(cnt);
            }
            object = this.up_prot.up(msg);
            return object;
        }
        finally {
            this.up_count.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        if (!this.up_threads) {
            this.up_prot.up(batch);
            return;
        }
        try {
            int cnt = this.up_count.incrementAndGet();
            AverageMinMax averageMinMax = this.avg_up;
            synchronized (averageMinMax) {
                this.avg_up.add(cnt);
            }
            this.up_prot.up(batch);
        }
        finally {
            this.up_count.decrementAndGet();
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg_up.clear();
        this.avg_down.clear();
    }
}

