/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.management;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.management.ManagementRuntimeAuthConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.management")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface ManagementConfig {
    public ManagementRuntimeAuthConfig auth();

    @WithDefault(value="9000")
    public int port();

    @WithDefault(value="9001")
    public int testPort();

    public String host();

    @WithDefault(value="true")
    public boolean hostEnabled();

    public ServerSslConfig ssl();

    public Optional<String> tlsConfigurationName();

    @WithName(value="handle-100-continue-automatically")
    @WithDefault(value="false")
    public boolean handle100ContinueAutomatically();

    public ServerLimitsConfig limits();

    @WithDefault(value="30M")
    public Duration idleTimeout();

    public BodyConfig body();

    @WithDefault(value="-1")
    public int acceptBacklog();

    @WithDefault(value="/var/run/io.quarkus.management.socket")
    public String domainSocket();

    @WithDefault(value="false")
    public boolean domainSocketEnabled();

    public Map<String, HeaderConfig> header();

    public Map<String, FilterConfig> filter();

    public ProxyConfig proxy();

    default public int determinePort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testPort() : this.port();
    }
}

