# generated by gen-config.py DO NOT edit

import typing
from kitty.conf.utils import KeyAction, KittensKeyMap
import kitty.conf.utils
from kitty.fast_data_types import Color
import kitty.fast_data_types
from kitty.types import ParsedShortcut
import kitty.types


option_names = (  # {{{
 'added_bg',
 'added_margin_bg',
 'background',
 'diff_cmd',
 'filler_bg',
 'foreground',
 'highlight_added_bg',
 'highlight_removed_bg',
 'hunk_bg',
 'hunk_margin_bg',
 'ignore_name',
 'map',
 'margin_bg',
 'margin_fg',
 'margin_filler_bg',
 'num_context_lines',
 'pygments_style',
 'removed_bg',
 'removed_margin_bg',
 'replace_tab_by',
 'search_bg',
 'search_fg',
 'select_bg',
 'select_fg',
 'syntax_aliases',
 'title_bg',
 'title_fg')  # }}}


class Options:
    added_bg: Color = Color(230, 255, 237)
    added_margin_bg: Color = Color(205, 255, 216)
    background: Color = Color(255, 255, 255)
    diff_cmd: str = 'auto'
    filler_bg: Color = Color(250, 251, 252)
    foreground: Color = Color(0, 0, 0)
    highlight_added_bg: Color = Color(172, 242, 189)
    highlight_removed_bg: Color = Color(253, 184, 192)
    hunk_bg: Color = Color(241, 248, 255)
    hunk_margin_bg: Color = Color(219, 237, 255)
    margin_bg: Color = Color(250, 251, 252)
    margin_fg: Color = Color(170, 170, 170)
    margin_filler_bg: typing.Optional[kitty.fast_data_types.Color] = None
    num_context_lines: int = 3
    pygments_style: str = 'default'
    removed_bg: Color = Color(255, 238, 240)
    removed_margin_bg: Color = Color(255, 220, 224)
    replace_tab_by: str = '    '
    search_bg: Color = Color(68, 68, 68)
    search_fg: Color = Color(255, 255, 255)
    select_bg: Color = Color(180, 213, 254)
    select_fg: typing.Optional[kitty.fast_data_types.Color] = Color(0, 0, 0)
    syntax_aliases: typing.Dict[str, str] = {'pyj': 'py', 'pyi': 'py', 'recipe': 'py'}
    title_bg: Color = Color(255, 255, 255)
    title_fg: Color = Color(0, 0, 0)
    ignore_name: typing.Dict[str, str] = {}
    map: typing.List[typing.Tuple[kitty.types.ParsedShortcut, kitty.conf.utils.KeyAction]] = []
    key_definitions: KittensKeyMap = {}
    config_paths: typing.Tuple[str, ...] = ()
    config_overrides: typing.Tuple[str, ...] = ()

    def __init__(self, options_dict: typing.Optional[typing.Dict[str, typing.Any]] = None) -> None:
        if options_dict is not None:
            null = object()
            for key in option_names:
                val = options_dict.get(key, null)
                if val is not null:
                    setattr(self, key, val)

    @property
    def _fields(self) -> typing.Tuple[str, ...]:
        return option_names

    def __iter__(self) -> typing.Iterator[str]:
        return iter(self._fields)

    def __len__(self) -> int:
        return len(self._fields)

    def _copy_of_val(self, name: str) -> typing.Any:
        ans = getattr(self, name)
        if isinstance(ans, dict):
            ans = ans.copy()
        elif isinstance(ans, list):
            ans = ans[:]
        return ans

    def _asdict(self) -> typing.Dict[str, typing.Any]:
        return {k: self._copy_of_val(k) for k in self}

    def _replace(self, **kw: typing.Any) -> "Options":
        ans = Options()
        for name in self:
            setattr(ans, name, self._copy_of_val(name))
        for name, val in kw.items():
            setattr(ans, name, val)
        return ans

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Any:
        k = option_names[key] if isinstance(key, int) else key
        try:
            return getattr(self, k)
        except AttributeError:
            pass
        raise KeyError(f"No option named: {k}")


defaults = Options()
defaults.ignore_name = {}
defaults.map = [
    # quit
    (ParsedShortcut(mods=0, key_name='q'), KeyAction('quit')),  # noqa
    # quit
    (ParsedShortcut(mods=0, key_name='ESCAPE'), KeyAction('quit')),  # noqa
    # scroll_down
    (ParsedShortcut(mods=0, key_name='j'), KeyAction('scroll_by', (1,))),  # noqa
    # scroll_down
    (ParsedShortcut(mods=0, key_name='DOWN'), KeyAction('scroll_by', (1,))),  # noqa
    # scroll_up
    (ParsedShortcut(mods=0, key_name='k'), KeyAction('scroll_by', (-1,))),  # noqa
    # scroll_up
    (ParsedShortcut(mods=0, key_name='UP'), KeyAction('scroll_by', (-1,))),  # noqa
    # scroll_top
    (ParsedShortcut(mods=0, key_name='HOME'), KeyAction('scroll_to', ('start',))),  # noqa
    # scroll_bottom
    (ParsedShortcut(mods=0, key_name='END'), KeyAction('scroll_to', ('end',))),  # noqa
    # scroll_page_down
    (ParsedShortcut(mods=0, key_name='PAGE_DOWN'), KeyAction('scroll_to', ('next-page',))),  # noqa
    # scroll_page_down
    (ParsedShortcut(mods=0, key_name=' '), KeyAction('scroll_to', ('next-page',))),  # noqa
    # scroll_page_up
    (ParsedShortcut(mods=0, key_name='PAGE_UP'), KeyAction('scroll_to', ('prev-page',))),  # noqa
    # next_change
    (ParsedShortcut(mods=0, key_name='n'), KeyAction('scroll_to', ('next-change',))),  # noqa
    # prev_change
    (ParsedShortcut(mods=0, key_name='p'), KeyAction('scroll_to', ('prev-change',))),  # noqa
    # all_context
    (ParsedShortcut(mods=0, key_name='a'), KeyAction('change_context', ('all',))),  # noqa
    # default_context
    (ParsedShortcut(mods=0, key_name='='), KeyAction('change_context', ('default',))),  # noqa
    # increase_context
    (ParsedShortcut(mods=0, key_name='+'), KeyAction('change_context', (5,))),  # noqa
    # decrease_context
    (ParsedShortcut(mods=0, key_name='-'), KeyAction('change_context', (-5,))),  # noqa
    # search_forward
    (ParsedShortcut(mods=0, key_name='/'), KeyAction('start_search', (True, False))),  # noqa
    # search_backward
    (ParsedShortcut(mods=0, key_name='?'), KeyAction('start_search', (True, True))),  # noqa
    # next_match
    (ParsedShortcut(mods=0, key_name='.'), KeyAction('scroll_to', ('next-match',))),  # noqa
    # next_match
    (ParsedShortcut(mods=0, key_name='>'), KeyAction('scroll_to', ('next-match',))),  # noqa
    # prev_match
    (ParsedShortcut(mods=0, key_name=','), KeyAction('scroll_to', ('prev-match',))),  # noqa
    # prev_match
    (ParsedShortcut(mods=0, key_name='<'), KeyAction('scroll_to', ('prev-match',))),  # noqa
    # search_forward_simple
    (ParsedShortcut(mods=0, key_name='f'), KeyAction('start_search', (False, False))),  # noqa
    # search_backward_simple
    (ParsedShortcut(mods=0, key_name='b'), KeyAction('start_search', (False, True))),  # noqa
]
