/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class JRubyScriptEngineManager {
    private final ScriptEngineFactory[] factories;
    private final Map<String, ScriptEngineFactory> nameMap = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> extensionMap = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> mimetypeMap = new HashMap<String, ScriptEngineFactory>();
    private Bindings globalMap = new SimpleBindings();

    public JRubyScriptEngineManager() {
        this(null);
    }

    public JRubyScriptEngineManager(ClassLoader loader) {
        ArrayList<ScriptEngineFactory> factories = new ArrayList<ScriptEngineFactory>();
        for (ScriptEngineFactory factory : ServiceLoader.load(ScriptEngineFactory.class, loader)) {
            for (String name2 : factory.getNames()) {
                this.nameMap.put(name2, factory);
            }
            for (String extension : factory.getExtensions()) {
                this.extensionMap.put(extension, factory);
            }
            for (String mimeType : factory.getMimeTypes()) {
                this.mimetypeMap.put(mimeType, factory);
            }
            factories.add(factory);
        }
        if (factories.isEmpty()) {
            throw new IllegalStateException("no javax.script.ScriptEngineFactory service");
        }
        this.factories = factories.toArray(new ScriptEngineFactory[factories.size()]);
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Null bindings");
        }
        this.globalMap = bindings;
    }

    public Bindings getBindings() {
        return this.globalMap;
    }

    public void put(String key2, Object value2) {
        this.globalMap.put(key2, value2);
    }

    public Object get(String key2) {
        return this.globalMap.get(key2);
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException("Null name");
        }
        ScriptEngineFactory factory = this.nameMap.get(shortName);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + shortName);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException("Null extension");
        }
        ScriptEngineFactory factory = this.extensionMap.get(extension);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + extension);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("Null mimeType");
        }
        ScriptEngineFactory factory = this.mimetypeMap.get(mimeType);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + mimeType);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.factories));
    }

    public void registerEngineName(String name2, ScriptEngineFactory factory) {
        Objects.requireNonNull(name2, "name");
        Objects.requireNonNull(factory, "factory");
        this.nameMap.put(name2, factory);
    }

    public void registerEngineMimeType(String type2, ScriptEngineFactory factory) {
        Objects.requireNonNull(type2, "type");
        Objects.requireNonNull(factory, "factory");
        this.mimetypeMap.put(type2, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        Objects.requireNonNull(extension, "extension");
        Objects.requireNonNull(factory, "factory");
        this.extensionMap.put(extension, factory);
    }
}

