/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(i64vec3(-20l, -20l, -20l), i64vec3(-30l, -30l, 30l), bvec3(true, false, true)) => i64vec3(-30l, -20l, 30l)
 * mix(i64vec3(-20l, 20l, 20l), i64vec3(30l, -30l, -30l), bvec3(false, true, false)) => i64vec3(-20l, -30l, 20l)
 * mix(i64vec3(20l, 20l, -20l), i64vec3(30l, 30l, -30l), bvec3(true, false, true)) => i64vec3(30l, 20l, -30l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(mix(i64vec3(-20l, -20l, -20l), i64vec3(-30l, -30l, 30l), bvec3(true, false, true)), i64vec3(-30l, -20l, 30l))) ? 1 : -1] array0;
  float[all(equal(mix(i64vec3(-20l, 20l, 20l), i64vec3(30l, -30l, -30l), bvec3(false, true, false)), i64vec3(-20l, -30l, 20l))) ? 1 : -1] array1;
  float[all(equal(mix(i64vec3(20l, 20l, -20l), i64vec3(30l, 30l, -30l), bvec3(true, false, true)), i64vec3(30l, 20l, -30l))) ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
